import { apiGet } from "./http";
import { HydraCollection } from "../models/hydra";
import { RegionEvolutionPoint } from "../models/RegionEvolution";
import { DepartmentCorrelationPoint } from "../models/DepartmentCorrelation";

export type TaxType = "tfpnb" | "tfpb" | "th" | "cfe";

export interface RegionEvolutionParams {
  tax?: TaxType;
  startYear?: number;
  endYear?: number;
}

export interface DepartmentCorrelationParams {
  tax?: TaxType;
  year?: number;
  department?: string;
}

export function getDepartmentCorrelation(params?: DepartmentCorrelationParams) {
  const queryParams = new URLSearchParams();

  if (params?.tax) {
    queryParams.append("tax", params.tax);
  }

  if (params?.year) {
    queryParams.append("year", params.year.toString());
  }

  if (params?.department) {
    queryParams.append("department", params.department);
  }

  const queryString = queryParams.toString();
  const url = `/stats/department-correlation${queryString ? `?${queryString}` : ""}`;

  return apiGet<HydraCollection<DepartmentCorrelationPoint>>(url);
}

export function getRegionEvolution(params?: RegionEvolutionParams) {
  const queryParams = new URLSearchParams();

  if (params?.tax) {
    queryParams.append("tax", params.tax);
  }
  if (params?.startYear) {
    queryParams.append("startYear", params.startYear.toString());
  }
  if (params?.endYear) {
    queryParams.append("endYear", params.endYear.toString());
  }

  const queryString = queryParams.toString();
  const url = `/stats/region-evolution${queryString ? `?${queryString}` : ""}`;

  return apiGet<HydraCollection<RegionEvolutionPoint>>(url);
}
