<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\OpenApi\Model\Operation as OpenApiOperation;
use ApiPlatform\OpenApi\Model\Parameter;
use App\State\RegionalDistributionProvider;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/stats/regional-distribution',
            provider: RegionalDistributionProvider::class,
            paginationEnabled: false,
            openapi: new OpenApiOperation(
                parameters: [
                    new Parameter(
                        name: 'year',
                        in: 'query',
                        description: 'Année',
                        required: false,
                        schema: ['type' => 'integer', 'default' => 2022]
                    ),
                ]
            )
        ),
    ]
)]
final class RegionalDistribution
{
    #[ApiProperty(identifier: true)]
    public string $regionCode;

    public string $regionName;

    public float $collectedVolume;
}
