<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\OpenApi\Model\Operation as OpenApiOperation;
use ApiPlatform\OpenApi\Model\Parameter;
use App\State\DepartmentCorrelationProvider;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/stats/department-correlation',
            provider: DepartmentCorrelationProvider::class,
            paginationEnabled: false,
            openapi: new OpenApiOperation(
                parameters: [
                    new Parameter(
                        name: 'tax',
                        in: 'query',
                        description: 'Taxe ciblée (tfpnb, tfpb, th, cfe)',
                        required: false,
                        schema: ['type' => 'string', 'default' => 'tfpb']
                    ),
                    new Parameter(
                        name: 'year',
                        in: 'query',
                        description: 'Année',
                        required: false,
                        schema: ['type' => 'integer', 'default' => 2022]
                    ),
                    new Parameter(
                        name: 'department',
                        in: 'query',
                        description: 'Code département (ex: 59, 2A)',
                        required: false,
                        schema: ['type' => 'string']
                    ),
                ]
            )
        ),
    ]
)]
final class DepartmentCorrelationPoint
{
    #[ApiProperty(identifier: true)]
    public string $communeCode;

    public float $rate;

    public float $collectedVolume;
}
