import React from "react";
import GlassCard from "../components/layout/GlassCard";
import "./Dashboard.css";
import TimeSeriesSVG from "../components/charts/TimeSeries/TimeSeries";
import ScatterPlott from "../components/charts/ScatterPlot/ScatterPlot";
import CircularDiagram from "../components/charts/CircularDiagram/CircularDiagram";

const Dashboard: React.FC = () => {
  return (
    <div className="dashboard">
      <div className="dashboard-container">
        {/* Header */}
        <header className="dashboard-header">
          <GlassCard>
            <h1 className="dashboard-title">
              <span className="title-gradient">Tableau de Bord</span>
            </h1>
            <p className="dashboard-subtitle">
              Analyse des données immobilières en temps réel
            </p>
          </GlassCard>
        </header>

        {/* Main Chart */}
        <div className="chart-section">
          <GlassCard>
            <div className="chart-header">
              <h2 className="chart-title">Analyse par Commune</h2>
              {/* <div className="chart-controls">
                <button className="btn-glass">Jour</button>
                <button className="btn-glass active">Semaine</button>
                <button className="btn-glass">Mois</button>
              </div> */}
            </div>
            <TimeSeriesSVG />
            <ScatterPlott />
            <CircularDiagram />
          </GlassCard>
        </div>
      </div>
    </div>
  );
};

export default Dashboard;
