import React from "react";
import { TaxType } from "../../api/stats";

const TAX_LABELS: Record<TaxType, string> = {
  tfpnb: "tfpnb",
  tfpb: "tfpb",
  th: "th",
  cfe: "cfe",
};

type Props = {
  selectedTax: TaxType;
  onTaxChange: (t: TaxType) => void;
};

export const ControlTax: React.FC<Props> = ({
    selectedTax,
    onTaxChange,
}) => {
    return (
        <div className="control-group">
            <label className="control-label">Type de taxe</label>
            <div className="button-group">
            {(Object.keys(TAX_LABELS) as TaxType[]).map((tax) => (
                <button
                key={tax}
                className={`filter-button ${selectedTax === tax ? "active" : ""}`}
                onClick={() => onTaxChange(tax)}
                type="button"
                >
                {TAX_LABELS[tax]}
                </button>
            ))}
            </div>
        </div>
    );
};