import { fireEvent, render, screen } from "@testing-library/react";
import { TimeSeriesControls } from "./TimeSeriesControls";

describe("TimeSeriesControls", () => {
  it("affiche les filtres de taxe et les annees disponibles", () => {
    const onTaxChange = jest.fn();
    const onStartYearChange = jest.fn();
    const onEndYearChange = jest.fn();

    render(
      <TimeSeriesControls
        selectedTax="tfpb"
        startYear={2019}
        endYear={2022}
        onTaxChange={onTaxChange}
        onStartYearChange={onStartYearChange}
        onEndYearChange={onEndYearChange}
      />
    );

    expect(screen.getByRole("button", { name: "tfpnb" })).toBeInTheDocument();
    expect(screen.getByRole("button", { name: "tfpb" })).toBeInTheDocument();
    expect(screen.getByRole("button", { name: "th" })).toBeInTheDocument();
    expect(screen.getByRole("button", { name: "cfe" })).toBeInTheDocument();

    const selects = screen.getAllByRole("combobox");
    expect(selects).toHaveLength(2);

    const yearOptions = screen.getAllByRole("option").map((option) => option.textContent);
    expect(yearOptions).toContain("2019");
    expect(yearOptions).toContain("2020");
    expect(yearOptions).toContain("2021");
    expect(yearOptions).toContain("2022");
  });

  it("declenche les callbacks de filtre", () => {
    const onTaxChange = jest.fn();
    const onStartYearChange = jest.fn();
    const onEndYearChange = jest.fn();

    render(
      <TimeSeriesControls
        selectedTax="tfpb"
        startYear={2019}
        endYear={2022}
        onTaxChange={onTaxChange}
        onStartYearChange={onStartYearChange}
        onEndYearChange={onEndYearChange}
      />
    );

    fireEvent.click(screen.getByRole("button", { name: "cfe" }));
    expect(onTaxChange).toHaveBeenCalledWith("cfe");

    const [startSelect, endSelect] = screen.getAllByRole("combobox");
    fireEvent.change(startSelect, { target: { value: "2020" } });
    fireEvent.change(endSelect, { target: { value: "2021" } });

    expect(onStartYearChange).toHaveBeenCalledWith(2020);
    expect(onEndYearChange).toHaveBeenCalledWith(2021);
  });
});
