import React from "react";
import { TaxType } from "../../../api/stats";
import { DEPARTEMENTS } from "./scatterplot.utils";
import { ControlTax } from "../../utils/ControlTax";
import { ControlYear } from "../../utils/ControlYear";

type Props = {
  selectedTax: TaxType;
  year: number;
  department: string;
  onTaxChange: (t: TaxType) => void;
  onYearChange: (y: number) => void;
  onDepartmentChange: (y: string) => void;
};

export const ScatterPlotControls: React.FC<Props> = ({
    selectedTax,
    year,
    department,
    onTaxChange,
    onYearChange,
    onDepartmentChange,
}) => {
    return (
      <div className="controls-panel">
        
        <ControlTax
          selectedTax={selectedTax}
          onTaxChange={onTaxChange}
        />

        <ControlYear
          year={year}
          onYearChange={onYearChange}
        />

        <div className="control-group">
          <label className="control-label">Département</label>
  
          <div className="controls">
            <div className="selector">
              <span className="label">De</span>
              <select
                className="select"
                value={department}
                onChange={(e) => onDepartmentChange(String(e.target.value))}
              >
                  {Object.entries(DEPARTEMENTS).map(([department, nom]) => (
                    <option key={department} value={department}>
                      {nom}
                    </option>
                  ))}
              </select>
            </div>
          </div>
        </div>
      </div>
    );
};