import React from "react";
import { TaxType } from "../../../api/stats";
import { AVAILABLE_YEARS } from "./../../utils/chart.utils";

const TAX_LABELS: Record<TaxType, string> = {
  tfpnb: "tfpnb",
  tfpb: "tfpb",
  th: "th",
  cfe: "cfe",
};

type Props = {
  selectedTax: TaxType;
  startYear: number;
  endYear: number;
  onTaxChange: (t: TaxType) => void;
  onStartYearChange: (y: number) => void;
  onEndYearChange: (y: number) => void;
};

export const TimeSeriesControls: React.FC<Props> = ({
  selectedTax,
  startYear,
  endYear,
  onTaxChange,
  onStartYearChange,
  onEndYearChange,
}) => {
  return (
    <div className="controls-panel">
      <div className="control-group">
        <label className="control-label">Type de taxe</label>
        <div className="button-group">
          {(Object.keys(TAX_LABELS) as TaxType[]).map((tax) => (
            <button
              key={tax}
              className={`filter-button ${selectedTax === tax ? "active" : ""}`}
              onClick={() => onTaxChange(tax)}
              type="button"
            >
              {TAX_LABELS[tax]}
            </button>
          ))}
        </div>
      </div>

      <div className="control-group">
        <label className="control-label">Période</label>

        <div className="controls">
          <div className="selector">
            <span className="label">De</span>
            <select
              className="select"
              value={startYear}
              onChange={(e) => onStartYearChange(Number(e.target.value))}
            >
              {AVAILABLE_YEARS.map((year) => (
                <option key={year} value={year}>
                  {year}
                </option>
              ))}
            </select>
          </div>

          <div className="selector">
            <span className="label">À</span>
            <select
              className="select"
              value={endYear}
              onChange={(e) => onEndYearChange(Number(e.target.value))}
            >
              {AVAILABLE_YEARS.map((year) => (
                <option key={year} value={year}>
                  {year}
                </option>
              ))}
            </select>
          </div>
        </div>
      </div>
    </div>
  );
};
