import React, { useMemo } from "react";
import { RegionalDistributionPoint } from "../../../models/RegionalDistribution";
import { colorForRegion } from "./circulardiagram.utils";

type Props = {
  regionDetails: RegionalDistributionPoint[];
  showClose?: boolean;
  onClose?: () => void;
};

export const CircularDiagramDetail: React.FC<Props> = ({
  regionDetails,
  showClose,
  onClose,
}) => {

  const regionName = regionDetails[0].regionName
  const collectedVolume = regionDetails[0].collectedVolume

  return (
    <div className="details-panel">
      <div className="details-header">
        <h3 className="details-title">{regionName}</h3>
        <div
          className="details-color-indicator"
          style={{ backgroundColor: colorForRegion(regionName) }}
        />
      </div>

      <div className="details-stats">
        <div className="stat-card">
          <span className="stat-label">Volume collecté</span>
          <span className="stat-value">{collectedVolume.toLocaleString()}€</span>
        </div>
      </div>

      {showClose && (
        <button className="close-details-button" onClick={onClose} type="button">
          Fermer les détails
        </button>
      )}
    </div>
  );
};
