# 🇫🇷 Fullstack Lab - Visualisation des Impôts Locaux

Application de visualisation de données fiscales (Taux & Volumes) basée sur les données ouvertes de data.gouv.fr (Fichiers REI).

**Stack Technique :**
* **Backend :** API Platform (Symfony 6/7) + PostgreSQL
* **Frontend :** React / Next.js
* **Infrastructure :** Docker (Compose)

---

## 🚀 1. Pré-requis

* **Docker Desktop** installé et lancé.
* **Git**.
* Le fichier de données CSV (voir ci-dessous).

---

## 🛠️ 2. Installation & Démarrage (Premier lancement)

### A. Lancement des conteneurs
Ouvre un terminal à la racine du projet et lance :

```bash
docker compose up -d --build
```

### B. Installation des dépendances et Base de données
Une fois les conteneurs verts (vérifie sur Docker Desktop), lance ces commandes une par une :

```Bash
# 1. Installer les dépendances PHP (Vendor)
docker compose exec php composer install

# 2. Créer la structure de la base de données
docker compose exec php bin/console doctrine:schema:update --force

# 3. Importer les données (ETL) - Peut prendre 1 à 2 minutes
docker compose exec php bin/console doctrine:fixtures:load --no-interaction
```
🎉 C'est prêt !

 - API & Docs : http://localhost:8000/api

 - Frontend : http://localhost:3000

 - Admin DB (Optionnel) : Port 5433 (User: app, Pass: root, DB: app)

## ⚙️ Commandes Utiles au quotidien
Arrêter le projet
```Bash
docker compose stop
```
Relancer le projet
```Bash
docker compose up -d
```
Vider le cache (En cas de bug mystique)
```Bash
docker compose exec php bin/console cache:clear
```
Accéder au terminal du Backend
```Bash
docker compose exec php sh
```



