import { RegionalDistributionPoint } from "../../../models/RegionalDistribution";

export const WIDTH = 950;
export const HEIGHT = 580;
export const MARGIN = { top: 20, right: 20, bottom: 55, left: 70 };

export const AVAILABLE_YEARS = [2019, 2020, 2021, 2022, 2023];

export function colorForRegion(name: string) {
  const palette = [
    "#1e3a8a", // Blue 900 (Foncé)
    "#1e40af", // Blue 800
    "#1d4ed8", // Blue 700
    "#2563eb", // Blue 600
    "#3b82f6", // Blue 500
    "#60a5fa", // Blue 400
    "#93c5fd", // Blue 300
    "#bfdbfe", // Blue 200
    "#dbeafe", // Blue 100
    "#eff6ff", // Blue 50 (Très clair)
  ];
  let hash = 0;
  for (let i = 0; i < name.length; i++) hash = (hash * 31 + name.charCodeAt(i)) >>> 0;
  return palette[hash % palette.length];
}

export function groupByRegion(raw: RegionalDistributionPoint[]) {
  const map = new Map<string, RegionalDistributionPoint[]>();
  for (const p of raw) {
    if (!map.has(p.regionName)) map.set(p.regionName, []);
    map.get(p.regionName)!.push(p);
  }
  for (const [name, arr] of Array.from(map.entries())) {
    arr.sort((a, b) => a.collectedVolume - b.collectedVolume);
    map.set(name, arr);
  }
  return map;
}

export function padDomain([min, max]: [number, number], ratio = 0.15): [number, number] {
  if (!isFinite(min) || !isFinite(max)) return [0, 1];
  if (min === max) return [min - 1, max + 1];
  const pad = (max - min) * ratio;
  return [min - pad, max + pad];
}

export function distanceToPoint(
  px: number,
  py: number,
  x: number,
  y: number,
) {
  return Math.hypot(px - x, py - y);
}

export function extent(values: number[]): [number, number] {
  let min = Infinity;
  let max = -Infinity;
  for (const v of values) {
    if (v < min) min = v;
    if (v > max) max = v;
  }
  return [min, max];
}

export function scaleLinear(domain: [number, number], range: [number, number]) {
  const [d0, d1] = domain;
  const [r0, r1] = range;
  const m = d1 === d0 ? 0 : (r1 - r0) / (d1 - d0);
  return (x: number) => r0 + (x - d0) * m;
}