<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\Metadata\Get;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ApiResource(
    // On désactive l'écriture via l'API (US-02 : c'est un import CSV qui remplira la base)
    operations: [
        new Get(),
        new GetCollection()
    ],
    paginationEnabled: true,
    paginationItemsPerPage: 20
)]
// Ajout d'index pour accélérer les recherches et agrégations futures (US-03)
#[ORM\Index(columns: ['year'], name: 'idx_year')]
#[ORM\Index(columns: ['department_code'], name: 'idx_dept')]
#[ORM\Index(columns: ['region_code'], name: 'idx_region')]
class TaxData
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column]
    private ?int $year = null;

    #[ORM\Column(length: 10)]
    private ?string $regionCode = null;

    #[ORM\Column(length: 255)]
    private ?string $regionName = null;

    // String car "2A" ou "2B" pour la Corse
    #[ORM\Column(length: 10)]
    private ?string $departmentCode = null;

    #[ORM\Column(length: 10)]
    private ?string $communeCode = null;

    // --- TAUX (Float pour permettre les décimales) ---

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $rateTFPNB = null;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $rateTFPB = null;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $rateTH = null;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $rateCFE = null;

    // --- VOLUMES ---
    // On stocke le montant total collecté (ou base nette)
    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $collectedVolume = null;

    // --- Getters et Setters ---

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getYear(): ?int
    {
        return $this->year;
    }

    public function setYear(int $year): self
    {
        $this->year = $year;
        return $this;
    }

    public function getRegionCode(): ?string
    {
        return $this->regionCode;
    }

    public function setRegionCode(string $regionCode): self
    {
        $this->regionCode = $regionCode;
        return $this;
    }

    public function getRegionName(): ?string
    {
        return $this->regionName;
    }

    public function setRegionName(string $regionName): self
    {
        $this->regionName = $regionName;
        return $this;
    }

    public function getDepartmentCode(): ?string
    {
        return $this->departmentCode;
    }

    public function setDepartmentCode(string $departmentCode): self
    {
        $this->departmentCode = $departmentCode;
        return $this;
    }

    public function getCommuneCode(): ?string
    {
        return $this->communeCode;
    }

    public function setCommuneCode(string $communeCode): self
    {
        $this->communeCode = $communeCode;
        return $this;
    }

    public function getRateTFPNB(): ?float
    {
        return $this->rateTFPNB;
    }

    public function setRateTFPNB(?float $rateTFPNB): self
    {
        $this->rateTFPNB = $rateTFPNB;
        return $this;
    }

    public function getRateTFPB(): ?float
    {
        return $this->rateTFPB;
    }

    public function setRateTFPB(?float $rateTFPB): self
    {
        $this->rateTFPB = $rateTFPB;
        return $this;
    }

    public function getRateTH(): ?float
    {
        return $this->rateTH;
    }

    public function setRateTH(?float $rateTH): self
    {
        $this->rateTH = $rateTH;
        return $this;
    }

    public function getRateCFE(): ?float
    {
        return $this->rateCFE;
    }

    public function setRateCFE(?float $rateCFE): self
    {
        $this->rateCFE = $rateCFE;
        return $this;
    }

    public function getCollectedVolume(): ?float
    {
        return $this->collectedVolume;
    }

    public function setCollectedVolume(?float $collectedVolume): self
    {
        $this->collectedVolume = $collectedVolume;
        return $this;
    }
}