<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\OpenApi\Model\Operation as OpenApiOperation;
use ApiPlatform\OpenApi\Model\Parameter;
use App\State\RegionEvolutionProvider;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/stats/region-evolution',
            provider: RegionEvolutionProvider::class,
            paginationEnabled: false,
            openapi: new OpenApiOperation(
                parameters: [
                    new Parameter(
                        name: 'tax',
                        in: 'query',
                        description: 'Taxe ciblée (tfpnb, tfpb, th, cfe)',
                        required: false,
                        schema: ['type' => 'string', 'default' => 'tfpb']
                    ),
                    new Parameter(
                        name: 'startYear',
                        in: 'query',
                        description: 'Année de début',
                        required: false,
                        schema: ['type' => 'integer', 'default' => 2022]
                    ),
                    new Parameter(
                        name: 'endYear',
                        in: 'query',
                        description: 'Année de fin',
                        required: false,
                        schema: ['type' => 'integer', 'default' => 2022]
                    ),
                ]
            )
        ),
    ]
)]
final class RegionEvolutionPoint
{
    #[ApiProperty(identifier: true)]
    public string $id;

    public int $year;

    public string $regionCode;

    public string $regionName;

    public float $rate;
}
