import { RegionEvolutionPoint } from "../../../models/RegionEvolution";

export const WIDTH = 950;
export const HEIGHT = 380;
export const MARGIN = { top: 20, right: 20, bottom: 55, left: 60 };

export function groupByRegion(raw: RegionEvolutionPoint[]) {
  const map = new Map<string, RegionEvolutionPoint[]>();
  for (const p of raw) {
    if (!map.has(p.regionName)) map.set(p.regionName, []);
    map.get(p.regionName)!.push(p);
  }
  for (const [name, arr] of Array.from(map.entries())) {
    arr.sort((a, b) => a.year - b.year);
    map.set(name, arr);
  }
  return map;
}
export function distanceToSegment(
  px: number,
  py: number,
  x1: number,
  y1: number,
  x2: number,
  y2: number
) {
  const dx = x2 - x1;
  const dy = y2 - y1;
  if (dx === 0 && dy === 0) return Math.hypot(px - x1, py - y1);

  const t = Math.max(
    0,
    Math.min(1, ((px - x1) * dx + (py - y1) * dy) / (dx * dx + dy * dy))
  );
  const projX = x1 + t * dx;
  const projY = y1 + t * dy;
  return Math.hypot(px - projX, py - projY);
}

export function colorForRegion(name: string) {
  const palette = [
    "#6366f1",
    "#8b5cf6",
    "#ec4899",
    "#10b981",
    "#3b82f6",
    "#f59e0b",
    "#06b6d4",
    "#a855f7",
    "#84cc16",
    "#f43f5e",
  ];
  let hash = 0;
  for (let i = 0; i < name.length; i++) hash = (hash * 31 + name.charCodeAt(i)) >>> 0;
  return palette[hash % palette.length];
}

