import React, { useState } from "react";
import GlassCard from "../components/layout/GlassCard";
import "./Dashboard.css";
import TimeSeriesSVG from "../components/charts/TimeSeries/TimeSeries";
import ScatterPlott from "../components/charts/ScatterPlot/ScatterPlot";
import CircularDiagram from "../components/charts/CircularDiagram/CircularDiagram";

type ChartType = 'timeseries' | 'scatter' | 'circular';

const Dashboard: React.FC = () => {
  const [selectedChart, setSelectedChart] = useState<ChartType>('timeseries');

  const charts = {
    timeseries: {
      component: <TimeSeriesSVG />,
      title: "Analyse Temporelle",
    },
    scatter: {
      component: <ScatterPlott />,
      title: "Diagramme de Dispersion",
    },
    circular: {
      component: <CircularDiagram />,
      title: "Diagramme Circulaire",
    }
  };

  return (
    <div className="dashboard">
      <div className="dashboard-container">
        {/* Header */}
        <header className="dashboard-header">
          <GlassCard>
            <h1 className="dashboard-title">
              <span className="title-gradient">Tableau de Bord</span>
            </h1>
          </GlassCard>
        </header>

        {/* Chart Selection Tabs */}
        <div className="chart-tabs">
          <GlassCard>
            <div className="tabs-container">
              {(Object.keys(charts) as ChartType[]).map((chartType) => (
                <button
                  key={chartType}
                  className={`tab-button ${selectedChart === chartType ? 'active' : ''}`}
                  onClick={() => setSelectedChart(chartType)}
                >
                  <span className="tab-label">{charts[chartType].title}</span>
                </button>
              ))}
            </div>
          </GlassCard>
        </div>

        {/* Selected Chart */}
        <div className="chart-section">
          <GlassCard>
            <div className="chart-header">
              <h2 className="chart-title">
                {charts[selectedChart].title}
              </h2>
            </div>
            <div className="chart-content">
              {charts[selectedChart].component}
            </div>
          </GlassCard>
        </div>
      </div>
    </div>
  );
};

export default Dashboard;
