import React from "react";
import { AVAILABLE_YEARS } from "./chart.utils";

type Props = {
  year: number;
  onYearChange: (y: number) => void;
};

export const ControlYear: React.FC<Props> = ({
    year,
    onYearChange,
}) => {
    return (
        <div className="control-group">
            <label className="control-label">Année</label>

            <div className="controls">
            <div className="selector">
                <span className="label">En</span>
                <select
                className="select"
                value={year}
                onChange={(e) => onYearChange(Number(e.target.value))}
                >
                {AVAILABLE_YEARS.map((year) => (
                    <option key={year} value={year}>
                    {year}
                    </option>
                ))}
                </select>
            </div>
            </div>
        </div>
    );
};