import React from "react";
import { TaxType } from "../../../api/stats";
import { ControlTax } from "../../utils/ControlTax";
import { ControlYear } from "../../utils/ControlYear";

type Props = {
  selectedTax: TaxType;
  year: number;
  onTaxChange: (t: TaxType) => void;
  onYearChange: (y: number) => void;
};

export const CircularDiagramControls: React.FC<Props> = ({
    selectedTax,
    year,
    onTaxChange,
    onYearChange,
}) => {
    return (
      <div className="controls-panel">
        <ControlTax
          selectedTax={selectedTax}
          onTaxChange={onTaxChange}
        />

        <ControlYear
          year={year}
          onYearChange={onYearChange}
        />
      </div>
    );
};