# 🇫🇷 Fullstack Lab - Visualisation des Impôts Locaux

Application de visualisation de données fiscales (Taux & Volumes) basée sur les données ouvertes de data.gouv.fr (Fichiers REI).

**Stack Technique :**
* **Backend :** API Platform (Symfony 6/7) + PostgreSQL
* **Frontend :** React / Next.js
* **Infrastructure :** Docker (Compose)

---

## 🚀 1. Pré-requis

* **Docker Desktop** installé et lancé.
* **Git**.
* Le fichier de données CSV (voir ci-dessous).

---

## 🛠️ 2. Installation & Démarrage (Premier lancement)

### A. Lancement des conteneurs
Ouvre un terminal à la racine du projet et lance :

```bash
docker compose up -d --build
```

### B. Installation des dépendances et Base de données
Une fois les conteneurs verts (vérifie sur Docker Desktop), lance ces commandes une par une :

```Bash
# 1. Installer les dépendances PHP (Vendor)
docker compose exec php composer install

# 2. Créer la structure de la base de données
docker compose exec php bin/console doctrine:schema:update --force

# 3. Importer les données (ETL) - Peut prendre 1 à 2 minutes
docker compose exec -e XDEBUG_MODE=off php bin/console doctrine:fixtures:load --no-interaction --no-debug
```
🎉 C'est prêt !

 - API & Docs : http://localhost:8000/api

 - Frontend : http://localhost:3000

 - Admin DB (Optionnel) : Port 5433 (User: app, Pass: root, DB: app)

## ⚙️ Commandes Utiles au quotidien
Arrêter le projet
```Bash
docker compose stop
```
Relancer le projet
```Bash
docker compose up -d
```
Vider le cache (En cas de bug mystique)
```Bash
docker compose exec php bin/console cache:clear
```
Accéder au terminal du Backend
```Bash
docker compose exec php sh
```
Supprimer des anciennes données et mettre à jour le schéma
```Bash
sudo docker compose exec php bin/console doctrine:schema:drop --force --full-database
sudo docker compose exec php bin/console doctrine:schema:update --force
```

## ✅ Tests

### Protocole reproductible (ordre recommandé)
Lancer les tests dans cet ordre pour la soutenance :

```bash
# 1) Vérifier les services
docker compose ps

# 2) Tests API backend
docker compose exec php sh -lc "cd /app && APP_ENV=test php bin/console doctrine:database:create --if-not-exists"
docker compose exec php sh -lc "cd /app && APP_ENV=test php bin/console doctrine:schema:update --force"
docker compose exec php sh -lc "cd /app && APP_ENV=test SYMFONY_PHPUNIT_VERSION=9.6 vendor/bin/simple-phpunit tests/Api/StatsEndpointsTest.php"

# 3) Tests frontend unitaires
docker compose exec frontend npm test -- --watchAll=false

# 4) Tests end-to-end Playwright
cd e2e
npm install
npx playwright install --with-deps chromium
npx playwright test
npx playwright show-report
```

### Résultats attendus
- Backend API : `OK` et `0 failures` sur `StatsEndpointsTest`.
- Frontend : suite de tests verte.
- E2E : `5 passed`.

### Cas couverts par les tests API (US-08)
- Endpoints d'agrégation fonctionnels :
  - `/api/stats/region-evolution`
  - `/api/stats/department-correlation`
  - `/api/stats/regional-distribution`
- Cas limites et négatifs :
  - `startYear > endYear` retourne une collection vide.
  - `department` inconnu ou absent retourne vide.
  - `tax` invalide tombe sur la valeur par défaut (`tfpb`).
  - année inconnue retourne vide.
  - vérification que la distribution régionale dépend bien de la taxe choisie.

### Cas couverts par les tests E2E (US-08)
- Affichage du dashboard et présence des 3 visualisations.
- Interaction utilisateur sur les filtres (taxes / périodes / département).
- Vérification des appels API utilisés par le front.
- Vérification que les réponses contiennent des données exploitables.
- Cas négatif E2E : période invalide (pas de données).

### Preuves à montrer pendant la soutenance
- Sortie console des tests API (backend).
- Sortie console des tests E2E (`5 passed`).
- Rapport HTML Playwright (`npx playwright show-report`).
- Capture de l'onglet Network montrant des payloads agrégés et légers.
