#include "../include/common.h"

/* =========================================================
   Le client génère des nombres aléatoires via ses processus
   fils et envoie les résultats au serveur pour fusion
   ========================================================= */

int main(int argc, char *argv[]) {

    if (argc != 5) {
        printf("Usage : %s IP PORT rand|drand48 ID_CLIENT\n", argv[0]);
        return 1;
    }

    char *ip = argv[1];
    int port = atoi(argv[2]);
    int use_drand48 = strcmp(argv[3], "drand48") == 0;
    int id_client = atoi(argv[4]);

    printf("\n===== CLIENT %d =====\n", id_client);
    printf("Processus père | PID=%d\n", getpid());

    for (int i = 0; i < NB_PROCESSUS; i++) {

        pid_t pid = fork();

        if (pid == 0) {   /* ===== PROCESSUS FILS ===== */

            uint64_t local[NB_VALEURS] = {0};

            srand(time(NULL) ^ getpid());
            srand48(time(NULL) ^ getpid());

            time_t debut = time(NULL);

            for (uint64_t k = 0; k < NB_TIRAGES; k++) {
                int r = use_drand48 ?
                        (int)(drand48() * NB_VALEURS) :
                        rand() % NB_VALEURS;
                local[r]++;
            }

            time_t fin = time(NULL);

            printf("Processus %d (fils) | PID=%d | Tirages=%lu | Temps=%lds\n",
                   i, getpid(), NB_TIRAGES, fin - debut);

            /* ===== ENVOI AU SERVEUR ===== */
            int sock = socket(AF_INET, SOCK_STREAM, 0);

            struct sockaddr_in serv;
            serv.sin_family = AF_INET;
            serv.sin_port = htons(port);
            serv.sin_addr.s_addr = inet_addr(ip);

            connect(sock, (struct sockaddr*)&serv, sizeof(serv));

            send(sock, local, sizeof(local), 0);

            /* Confirmation serveur */
            char ack[4];
            recv(sock, ack, sizeof(ack), 0);

            printf("Processus %d : données envoyées et confirmées\n", i);

            close(sock);
            exit(0);
        }
    }

    while (wait(NULL) > 0);
    printf("Client %d terminé\n", id_client);

    return 0;
}
