# 👥 Auteurs
Jeverson Sylcarin Bramo 
Brinda Djitue

# Étude des générateurs pseudo-aléatoires rand() et drand48()

Ce projet a pour objectif d’analyser et de comparer le comportement des générateurs pseudo-aléatoires rand() et drand48() en langage C.
L’étude repose sur une architecture client–serveur distribuée, utilisant le multi-processus, la mémoire partagée (SHM) et les sockets TCP, afin de répartir les calculs sur plusieurs processus et potentiellement sur plusieurs machines

## 🌟 Caractéristiques principales

### Architecture Distribuée

- Architecture client–serveur
- Support de plusieurs clients simultanés
- Communication réseau via sockets TCP
- Exécution possible sur plusieurs machines (via SSH)

### Multi-processus

- Création de plusieurs processus (12) avec fork()
- Chaque processus effectue ses propres tirages aléatoires
- Calculs locaux indépendants pour de meilleures performances

### Génération aléatoire

- Support de deux générateurs :
rand()
drand48()
- Choix du générateur via la ligne de commande
- Nombre de tirages paramétrable sans recompiler

### Mémoire partagée et synchronisation

- Utilisation de la mémoire partagée
- Protection des accès avec sémaphores
- Fusion sécurisée des résultats

## Analyse statistique

- Calcul des statistiques suivantes :
Nombre total de tirages
Occurrence minimale
Occurrence maximale
Ratio max/min
Écart-type
- Comparaison de la qualité de distribution entre rand() et drand48()

## 📋 Prérequis

- Système Linux / Unix
- Compilateur GCC
- Support:
fork
shm_open
mmap
semaphore
sockets TCP

## 🛠️ Installation

1. Clonez le dépôt :
```bash
git clone https://www-apps.univ-lehavre.fr/forge/bj244034/projet-systemes-exploitation.git
```

## Compilation
Le projet utilise un Makefile.
Depuis la racine du projet :

```bash
make
```
Les exécutables sont générés dans le dossier bin/ :
- bin/serveur
- bin/client
- bin/main

## 💻 Exécution

- Lancer le serveur (dans un premier terminal ou pc 1)

```bash
./bin/serveur 127.0.0.1 8080 rand
./bin/serveur 127.0.0.1 8080 drand48
```
Le serveur :
confirme la réception
fusionne les résultats
affiche les statistiques globales

- Lancer un client (dans un autre terminal ou pc 2)

```bash
./bin/client 127.0.0.1 8080 rand 1
./bin/client 127.0.0.1 8080 drand48 1
```
- Lancer plusieurs clients

```bash
./bin/client 127.0.0.1 8080 rand 2
./bin/client 127.0.0.1 8080 rand 3
```

Chaque client :
crée plusieurs processus
génère ses propres tirages
envoie son tableau d’occurrences au serveur

## 🔧 Paramétrage du programme
Les paramètres principaux sont définis dans include/common.h :
```
#define NB_PROCESSUS 12          // Nombre de processus par client/serveur
#define NB_VALEURS 1000          // Taille du tableau d’occurrences
#define NB_TIRAGES 2000000000LL  // Nombre de tirages par processus

```
 Ces valeurs peuvent être modifiées sans changer la logique du code.

## 📊 Structure du projet

```
├── include/
│   └── common.h        # Définition des constantes globales, structures partagées et prototypes communs
├── src/
│   ├── serveur.c       # Code source du serveur : gestion des clients, fusion des résultats et statistiques
│   ├── client.c        # Code source du client : génération de nombres aléatoires et envoi au serveur
│   └── main.c          # Programme principal pour lancer facilement serveur ou client 
├── bin/
│   ├── serveur         # Exécutable compilé du serveur
│   ├── client          # Exécutable compilé du client
│   └── main            # Exécutable compilé du programme principal
├── resultat.csv        # Fichier CSV contenant les résultats finaux : occurrences, ratios, statistiques
├── Makefile            # Fichier de compilation automatique pour générer les exécutables
└── README.md           # Documentation complète du projet, instructions d'utilisation et structure

```

## 🔍 Fonctionnement détaillé

1. Serveur
- Création du socket TCP
- Initialisation de la mémoire partagée et des sémaphores
- Création de processus serveur pour les calculs locaux
- Réception des tableaux envoyés par les clients
- Fusion sécurisée des résultats
- Calcul et affichage des statistiques globales
- Génération du fichier resultat.csv

2. Client
- Connexion au serveur
- Création de plusieurs processus via fork()
- Génération locale de nombres pseudo-aléatoires
- Calcul des occurrences
- Envoi du tableau d’occurrences au serveur
- Affichage détaillé de l’exécution des processus

3. common.h

- Définition des constantes globales :
nombre de processus
nombre de tirages
taille des tableaux
- Structures partagées (SHM)
- Prototypes communs

4. main.c

- Point d’entrée du projet
- Permet de lancer :
le serveur
ou le client
- Simplifie l’utilisation et les tests



## 📈 Objectifs pédagogiques atteints

- Comparaison de rand() et drand48()
- Utilisation correcte de fork()
- Programmation multi-processus
- Mémoire partagée et synchronisation
- Programmation réseau avec sockets
- Optimisation des performances
- Programme paramétrable

## ⚠️ Remarques

- Le serveur doit être lancé avant les clients
- Le programme peut être exécuté sur plusieurs machines via SSH
- Les performances dépendent du nombre de processus et de tirages
 
## 📄 Licence

Ce projet est distribué sous licence MIT.


