#ifndef COMMON_H
#define COMMON_H

/* ===================== INCLUDES ===================== */
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <math.h>

/* ===================== SOCKETS ===================== */
#include <sys/socket.h>
#include <arpa/inet.h>

/* ===================== SHM & SEM ===================== */
#include <sys/mman.h>
#include <fcntl.h>
#include <semaphore.h>

/* ===================== PARAMÈTRES ===================== */
/* Nombre de processus fils */
#define NB_PROCESSUS   12

/* Taille du tableau de répartition */
#define NB_VALEURS     100

/* Nombre de tirages par processus (modifiable ici) */
#define NB_TIRAGES     2000000000UL

/* Noms IPC */
#define SHM_NAME "/shm_l3_random"
#define SEM_NAME "/sem_l3_random"

/* ===================== STRUCTURE PARTAGÉE ===================== */
typedef struct {
    uint64_t occ[NB_VALEURS];  // occurrences globales
    uint64_t total;            // nombre total de tirages
} shm_data_t;

#endif
