#include "../include/common.h"

/* =========================================================
   Le serveur génère aussi ses propres nombres aléatoires,
   reçoit ceux des clients et fusionne le tout via SHM
   ========================================================= */

void afficher_stats(shm_data_t *shm, const char *gen) {

    uint64_t min = shm->occ[0];
    uint64_t max = shm->occ[0];
    double moyenne = (double)shm->total / NB_VALEURS;
    double variance = 0;

    for (int i = 0; i < NB_VALEURS; i++) {
        if (shm->occ[i] < min) min = shm->occ[i];
        if (shm->occ[i] > max) max = shm->occ[i];
        variance += pow(shm->occ[i] - moyenne, 2);
    }

    printf("\n===== STATISTIQUES SERVEUR (%s) =====\n", gen);
    printf("Total tirages : %lu\n", shm->total);
    printf("Min / Max     : %lu / %lu\n", min, max);
    printf("Ratio         : %.3f\n", (double)max / min);
    printf("Ecart-type    : %.2f\n", sqrt(variance / NB_VALEURS));
}

int main(int argc, char *argv[]) {

    if (argc != 4) {
        printf("Usage : %s IP PORT rand|drand48\n", argv[0]);
        return 1;
    }

    int port = atoi(argv[2]);
    int use_drand48 = strcmp(argv[3], "drand48") == 0;

    printf("\n===== SERVEUR =====\n");
    printf("Processus père | PID=%d\n", getpid());

    /* ===== MÉMOIRE PARTAGÉE ===== */
    int shm_fd = shm_open(SHM_NAME, O_CREAT | O_RDWR, 0666);
if (ftruncate(shm_fd, sizeof(shm_data_t)) == -1) {
    perror("ftruncate");
    exit(EXIT_FAILURE);
}


    shm_data_t *shm = mmap(NULL, sizeof(shm_data_t),
                           PROT_READ | PROT_WRITE,
                           MAP_SHARED, shm_fd, 0);

    memset(shm, 0, sizeof(shm_data_t));

    sem_t *sem = sem_open(SEM_NAME, O_CREAT, 0666, 1);

    /* ===== SOCKET ===== */
    int sock = socket(AF_INET, SOCK_STREAM, 0);

    struct sockaddr_in addr;
    addr.sin_family = AF_INET;
    addr.sin_port = htons(port);
    addr.sin_addr.s_addr = INADDR_ANY;

    bind(sock, (struct sockaddr*)&addr, sizeof(addr));
    listen(sock, 50);

    /* ===== PROCESSUS SERVEUR ===== */
    for (int i = 0; i < NB_PROCESSUS; i++) {

        if (fork() == 0) {

            uint64_t local[NB_VALEURS] = {0};

            srand(time(NULL) ^ getpid());
            srand48(time(NULL) ^ getpid());

            time_t debut = time(NULL);

            for (uint64_t k = 0; k < NB_TIRAGES; k++) {
                int r = use_drand48 ?
                        (int)(drand48() * NB_VALEURS) :
                        rand() % NB_VALEURS;
                local[r]++;
            }

            int cli = accept(sock, NULL, NULL);
            uint64_t recu[NB_VALEURS];
            recv(cli, recu, sizeof(recu), 0);

            sem_wait(sem);
            for (int j = 0; j < NB_VALEURS; j++) {
                shm->occ[j] += local[j] + recu[j];
                shm->total += local[j] + recu[j];
            }
            sem_post(sem);

            send(cli, "OK", 2, 0);
            close(cli);

            time_t fin = time(NULL);

            printf("Processus %d (serveur) | PID=%d | Temps=%lds | fusion OK\n",
                   i, getpid(), fin - debut);

            exit(0);
        }
    }

    while (wait(NULL) > 0);

    afficher_stats(shm, use_drand48 ? "drand48" : "rand");

    shm_unlink(SHM_NAME);
    sem_unlink(SEM_NAME);

    return 0;
}
