package fr.univ.dblp.simulation;

/**
 * États possibles d'un nœud dans le modèle épidémiologique SIS.
 *
 * Modèle SIS (Susceptible-Infected-Susceptible) :
 * - SUSCEPTIBLE : Peut être infecté
 * - INFECTED : Infecté et contagieux
 * - IMMUNE : Immunisé de manière permanente (antivirus à jour en permanence)
 */
public enum NodeState {
    /**
     * Nœud susceptible d'être infecté
     */
    SUSCEPTIBLE,

    /**
     * Nœud actuellement infecté (peut transmettre le virus)
     */
    INFECTED,

    /**
     * Nœud immunisé de manière permanente
     */
    IMMUNE
}
