# Script gnuplot pour visualiser la comparaison des réseaux
# Partie 2 - Question 6

set terminal png size 1400,900 font "Arial,14"
set output 'output/images/partie2_epidemic_networks.png'

set title "Propagation virale - Comparaison des topologies de réseaux\n{/*0.8 Modèle SIS sans immunisation (β=1/7, γ=2/30, 90 jours)}" font "Arial,16"
set xlabel "Temps (jours)" font "Arial,14"
set ylabel "Fraction d'infectés" font "Arial,14"

set grid
set key top right font "Arial,12"

set xrange [0:90]
set yrange [0:*]

# Couleurs distinctes
set style line 1 lc rgb '#E41A1C' lw 3 pt 7 ps 0.5  # Rouge - DBLP
set style line 2 lc rgb '#377EB8' lw 3 pt 7 ps 0.5  # Bleu - Aléatoire
set style line 3 lc rgb '#4DAF4A' lw 3 pt 7 ps 0.5  # Vert - Barabási-Albert

plot 'output/data/partie2_networks_comparison.dat' using 1:2 with lines ls 1 title "DBLP (loi de puissance, C≈0.63)", \
     '' using 1:3 with lines ls 2 title "Erdős-Rényi (aléatoire, C≈0.00002)", \
     '' using 1:4 with lines ls 3 title "Barabási-Albert (attachement préf., C≈0.005)"

print "Graphique généré: output/images/partie2_epidemic_networks.png"
