# Fit loi de puissance p_k = C * k^(-gamma)
set terminal png size 1200,800 font "Arial,14"
set output 'output/images/dd_powerlaw_fit.png'
set title "Fit loi de puissance - Réseau DBLP"
set xlabel "Degré k (log)"
set ylabel "Probabilité p_k (log)"
set logscale xy
set grid
set key bottom left

# Fonction loi de puissance: p_k = C * k^(-gamma)
f(x) = C * x**(-gamma)

# Valeurs initiales
gamma = 2.5
C = 1.0

# Fit sur données (ignorer k<10 pour éviter le bruit)
fit [10:] f(x) 'output/data/dblp_degree_distribution.dat' using 1:2 via gamma, C

# Afficher résultats
set label 1 sprintf("γ = %.2f", gamma) at graph 0.05, 0.25 font "Arial,16"
set label 2 sprintf("C = %.6f", C) at graph 0.05, 0.20 font "Arial,14"

plot 'output/data/dblp_degree_distribution.dat' using 1:2 with points pt 7 ps 0.8 lc rgb "blue" title "DBLP", \
     f(x) with lines lw 2 lc rgb "red" title sprintf("Fit: p_k = %.6f × k^{-%.2f}", C, gamma)
