# Comparaison des distributions pour les 3 réseaux
set terminal png size 1600,800 font "Arial,14"
set output 'output/images/comparison_all_networks.png'
set title "Comparaison distributions de degrés - DBLP vs Aléatoire vs Barabási-Albert"
set xlabel "Degré k (log)"
set ylabel "Probabilité p_k (log)"
set logscale xy
set grid
set key bottom left

plot 'output/data/dblp_degree_distribution.dat' using 1:2 with points pt 7 ps 0.8 lc rgb "blue" title "DBLP", \
     'output/data/random_degree_distribution.dat' using 1:2 with points pt 5 ps 0.8 lc rgb "green" title "Aléatoire", \
     'output/data/ba_degree_distribution.dat' using 1:2 with points pt 9 ps 0.8 lc rgb "red" title "Barabási-Albert"
