# Script gnuplot pour visualiser l'évolution détaillée - Scénario 1
# Partie 2 - Visualisation détaillée

set terminal png size 1400,900 font "Arial,14"
set output '../output/images/partie2_epidemic_detailed_scenario1.png'

set title "Propagation virale - Scénario 1 (50% immunisation aléatoire)\n{/*0.8 Modèle SIS - Évolution Susceptibles/Infectés}" font "Arial,16"
set xlabel "Temps (jours)" font "Arial,14"
set ylabel "Nombre de nœuds" font "Arial,14"

set grid
set key top right font "Arial,12"

set xrange [0:90]
set yrange [0:*]

# Couleurs
set style line 1 lc rgb '#377EB8' lw 3 pt 7 ps 0.5  # Bleu - Susceptibles
set style line 2 lc rgb '#E41A1C' lw 3 pt 7 ps 0.5  # Rouge - Infectés
set style line 3 lc rgb '#999999' lw 2 pt 7 ps 0.5  # Gris - Immunisés

plot '../output/data/partie2_Scenario_1_Immunisation_aleatoire.dat' using 1:2 with lines ls 1 title "Susceptibles", \
     '' using 1:3 with lines ls 2 title "Infectés", \
     '' using 1:4 with lines ls 3 title "Immunisés"

print "Graphique généré: output/images/partie2_epidemic_detailed_scenario1.png"
