# Script gnuplot pour visualiser les 3 scénarios sur le réseau Barabási-Albert
# Partie 2 - Question 6 - Réseau BA

set terminal png size 900,700 font "Arial,14"
set output '../output/images/partie2_BA_scenarios.png'

set title "Réseau Barabási-Albert - Comparaison des stratégies d'immunisation\n{/*0.8 Attachement préférentiel, C≈0.005}" font "Arial,16"

# Couleurs communes pour les 3 scénarios
set style line 1 lc rgb '#E41A1C' lw 3  # Rouge - Scénario 0
set style line 2 lc rgb '#377EB8' lw 3  # Bleu - Scénario 1
set style line 3 lc rgb '#4DAF4A' lw 3  # Vert - Scénario 2

set grid
set xrange [0:90]
set yrange [0:1]
set xlabel "Temps (jours)" font "Arial,12"
set ylabel "Fraction d'infectés" font "Arial,12"
set key top right font "Arial,11"

plot '../output/data/partie2_BA_scenarios.dat' using 1:2 with lines ls 1 title "Aucune intervention", \
     '' using 1:3 with lines ls 2 title "50% aléatoire", \
     '' using 1:4 with lines ls 3 title "50% sélective"

print "Graphique généré: output/images/partie2_BA_scenarios.png"
