##Analyse du Réseau de Collaboration Scientifique DBLP

**Cours**: Mesures de réseaux d'interaction

**Auteur**: Hamadou BA

---

## Introduction Générale

Ce travail présente une analyse complète du réseau de collaboration scientifique DBLP (Digital Bibliography & Library Project), structuré en deux volets complémentaires :

1. **Analyse structurelle** : Caractérisation topologique du réseau (propriétés statistiques, distribution des degrés, connexité, distance moyenne)
2. **Dynamique épidémique** : Étude de la propagation d'un virus informatique et évaluation de stratégies d'immunisation

Le réseau DBLP représente les collaborations entre chercheurs en informatique, où chaque nœud est un auteur et chaque arête matérialise une co-publication. Cette structure permet d'étudier les mécanismes de formation des réseaux sociaux et leurs implications pour la diffusion d'information.

**Données**: [SNAP - DBLP Collaboration Network](https://snap.stanford.edu/data/com-DBLP.html)
- **317,080** auteurs (nœuds)
- **~1,049,866** collaborations (arêtes)
- Type: Graphe non dirigé

---

# PARTIE 1 : Analyse Structurelle du Réseau DBLP

## 1. Mesures Fondamentales du Réseau

### 1.1 Statistiques de base

| Métrique | Valeur | Interprétation |
|----------|--------|----------------|
| Nombre de nœuds | 317,080 | Communauté scientifique de taille significative |
| Nombre d'arêtes | 1,049,866 | Réseau dense avec collaborations multiples |
| Degré moyen | 6.62 | Chaque chercheur collabore avec ~7 personnes en moyenne |
| Coefficient de clustering | **0.632** | Forte transitivité des relations |

### 1.2 Clustering: Une propriété remarquable

Le coefficient de clustering mesure la probabilité que deux voisins d'un nœud soient eux-mêmes connectés. Pour le réseau DBLP, C = **0.632** signifie que si deux chercheurs A et B collaborent tous deux avec C, il y a 63% de chances qu'ils collaborent ensemble.

**Comparaison avec un réseau aléatoire théorique** :

Pour un réseau aléatoire de même taille et degré moyen :
- C_aléatoire = <k> / N = 6.62 / 317,080 ≈ **0.0000209**

Le réseau DBLP a un clustering **30,000 fois plus élevé** qu'un réseau aléatoire! Cette propriété révèle une **forte structure en communautés** typique des réseaux sociaux, où "l'ami de mon ami est probablement mon ami".

---

## 2. Connexité et Cohésion du Réseau

### 2.1 Analyse de connexité

**Résultat**: Le réseau DBLP forme une **seule composante connexe**
- Il existe un chemin entre n'importe quelle paire de chercheurs
- Pas d'auteurs isolés ou de groupes déconnectés

### 2.2 Seuil théorique de connexité

Pour un réseau aléatoire de taille N, le degré moyen critique pour la connexité est :

**<k>_critique ≈ ln(N) = ln(317,080) ≈ 12.67**

**Observation** : Le réseau DBLP (avec <k> = 6.62) est en dessous du seuil théorique mais reste connexe. Cette apparente contradiction s'explique par sa structure non-aléatoire : le clustering élevé et la formation de communautés assurent la connexité même avec un degré moyen plus faible.

**Validation expérimentale** : Par génération de réseaux aléatoires, nous avons mesuré expérimentalement <k>_critique ≈ **12.5**, confirmant la prédiction théorique.

---

## 3. Distribution des Degrés : Un Réseau Sans Échelle

### 3.1 Visualisations

**Échelle linéaire** :
![Distribution linéaire](output/images/dd_dblp_linear.png)

En échelle linéaire, on observe une **queue lourde** (heavy tail) caractéristique : de nombreux chercheurs ont peu de collaborations, tandis que quelques auteurs très prolifiques (les **hubs**) accumulent des centaines de co-publications.

**Échelle log-log** :
![Distribution log-log](output/images/dd_dblp_loglog.png)

**Observation cruciale** : En échelle log-log, la distribution forme une **ligne droite** sur plusieurs ordres de grandeur.

### 3.2 Loi de puissance

La linéarité en log-log révèle une **loi de puissance** :

**p_k = C · k^(-γ)**

où:
- p_k : probabilité qu'un nœud ait degré k
- C : constante de normalisation
- γ : exposant de la loi de puissance

![Fit loi de puissance](output/images/dd_powerlaw_fit.png)

**Résultats du fit** (en excluant les petits degrés k < 10):
- **γ = 2.70 ± 0.04**
- **C ≈ 0.0002**
- **R² > 0.95** (excellent ajustement)

Cet exposant γ ≈ 2.7 est typique des **réseaux sans échelle** (scale-free networks) et cohérent avec d'autres réseaux sociaux (γ généralement entre 2 et 3).

### 3.3 Comparaison avec la distribution de Poisson

![Comparaison avec Poisson](output/images/dd_comparison.png)

La distribution de Poisson (en rouge), caractéristique des réseaux aléatoires d'Erdős-Rényi, ne correspond **absolument pas** aux données DBLP. Le réseau DBLP n'est pas aléatoire mais suit une logique d'**attachement préférentiel** où les auteurs établis attirent plus de nouvelles collaborations ("rich get richer").

---

## 4. Phénomène du Petit Monde

### 4.1 Distance moyenne

**Méthode** : Calcul par échantillonnage (1,000 nœuds) avec parcours en largeur (BFS)

| Métrique | Valeur |
|----------|--------|
| Distance moyenne | **6.84** |
| Distance maximale | 23 |
| Diamètre estimé | ~20-25 |

### 4.2 Hypothèse des "six degrés de séparation"

** CONFIRMÉE**

La distance moyenne de **6.84** confirme l'hypothèse des "six degrés de séparation" popularisée par Stanley Milgram : deux chercheurs quelconques du réseau sont séparés par une chaîne d'environ 6-7 intermédiaires.

**Comparaison théorique** :

Pour un réseau aléatoire de même taille :

ℓ ≈ ln(N) / ln(<k>) = ln(317,080) / ln(6.62) ≈ **6.5**

Le réseau DBLP (6.8) est légèrement plus grand qu'un réseau aléatoire (6.5), ce qui est attendu : la structure en communautés augmente légèrement les distances car il faut "sortir" de sa communauté pour atteindre des chercheurs distants.

### 4.3 Distribution des distances

![Distribution des distances](output/images/distances_dblp.png)

La distribution centrée autour de 6-7 avec une forme en cloche est caractéristique d'un **réseau petit monde** (small-world network).

### 4.4 Propriété "Small-World"

Le réseau DBLP combine deux propriétés apparemment contradictoires :

1. **Courtes distances moyennes** (~6.8) → comme un réseau aléatoire
2. **Clustering élevé** (0.632) → comme un réseau régulier

Cette combinaison définit les **réseaux petit monde**, théorisés par Watts et Strogatz (1998). Ces réseaux optimisent simultanément :
- **Efficacité de communication** (distances courtes)
- **Robustesse** (connexions locales redondantes)

---

## 5. Comparaison avec les Modèles Génératifs

### 5.1 Réseaux synthétiques générés

Pour valider notre compréhension du réseau DBLP, nous le comparons à deux modèles théoriques :

**1. Modèle d'Erdős-Rényi (réseau aléatoire)**
- Arêtes placées aléatoirement
- Génère une distribution de Poisson

**2. Modèle de Barabási-Albert (attachement préférentiel)**
- Nouveaux nœuds se connectent préférentiellement aux nœuds déjà bien connectés
- Génère une loi de puissance

### 5.2 Tableau comparatif

| Métrique | DBLP | Erdős-Rényi | Barabási-Albert |
|----------|------|-------------|-----------------|
| Taille | 317,080 | 50,000* | 50,000* |
| Degré moyen | 6.62 | 6.62 | 6.62 |
| **Clustering** | **0.632** | **0.00002** | **0.005** |
| Distance moyenne | 6.8 | 6.5 | 5.2 |
| **Distribution** | **Loi de puissance** | **Poisson** | **Loi de puissance** |
| **Exposant γ** | **2.70** | N/A | **3.0** |

*Taille réduite pour les modèles synthétiques (contraintes computationnelles)

![Comparaison des distributions](output/images/comparison_all_networks.png)

### 5.3 Analyse critique des modèles

**Modèle d'Erdős-Rényi** :
- Distribution de Poisson (pas de hubs)
- Clustering quasi-nul (0.00002)
- Distances courtes
- **Verdict** : Complètement inadéquat pour modéliser DBLP

**Modèle de Barabási-Albert** :
- Loi de puissance (γ ≈ 3.0)
- Présence de hubs
- Clustering très faible (0.005, soit **126× moins** que DBLP)
- Distances courtes
- **Verdict** : Reproduit la loi de puissance mais échoue à capturer le clustering social

**Réseau DBLP** :
- Loi de puissance (γ ≈ 2.7)
- Clustering très élevé (0.632)
- Distances courtes
- **Spécificité** : Combine loi de puissance ET clustering élevé

### 5.4 Conclusion sur la modélisation

Le réseau DBLP possède des propriétés que les modèles classiques ne reproduisent pas simultanément :

1. **Erdős-Rényi** : Trop simpliste, ignore la structure sociale
2. **Barabási-Albert** : Capture l'attachement préférentiel mais ignore la transitivité sociale

**Mécanismes réels nécessaires** :
- **Attachement préférentiel** : Les auteurs établis attirent plus de collaborations (→ loi de puissance)
- **Fermeture triadique** : Si A collabore avec B et C, alors B et C ont tendance à collaborer (→ clustering élevé)
- **Structure en communautés** : Groupes thématiques de recherche densément connectés

---

## 6. Question Bonus : Générateur par Copie

### 6.1 Motivation

Le modèle de Barabási-Albert reproduit la loi de puissance mais pas le clustering élevé observé dans les réseaux sociaux. Peut-on améliorer la modélisation?

### 6.2 Algorithme de copie

Pour chaque nouveau nœud u entrant dans le réseau :
1. Choisir un nœud v au hasard
2. Pour chaque voisin w de v :
   - Se connecter à w avec probabilité p
3. Se connecter à v (toujours)

**Intuition** : Cet algorithme crée naturellement des **triangles** (clustering) car le nouveau nœud se connecte à v ET aux voisins de v, formant des triades fermées.

### 6.3 Résultats (p = 0.3, N = 50,000)

| Métrique | Valeur |
|----------|--------|
| Nombre d'arêtes | 124,330 |
| Degré moyen | 4.97 |
| **Coefficient de clustering** | **0.48** |

### 6.4 Comparaison du clustering

| Modèle | Clustering | Ratio vs DBLP |
|--------|-----------|---------------|
| DBLP | 0.632 | 1.0× (référence) |
| **Copie (p=0.3)** | **0.48** | **0.76×** |
| Barabási-Albert | 0.005 | 0.008× |
| Erdős-Rényi | 0.00002 | 0.00003× |

**Amélioration spectaculaire** : Le modèle par copie génère un clustering **96× supérieur** à Barabási-Albert!

![Comparaison clustering (échelle linéaire)](output/images/clustering_comparison.png)

![Comparaison clustering (échelle log)](output/images/clustering_comparison_log.png)

### 6.5 Choix du paramètre p = 0.3

Le paramètre p contrôle le compromis entre clustering et degré moyen :

| p | Degré moyen | Clustering | Comportement |
|---|-------------|-----------|--------------|
| 0.3 | 4.97 | 0.48 |  Optimal |
| 0.5 | 21.23 | 0.44 | Croissance rapide |
| 0.7 | >253 | ~0.35 | Explosion du degré |

**Problème d'explosion** : À p élevé, le modèle devient instable. Quand un nouveau nœud se connecte à un hub ayant beaucoup de voisins, il hérite d'un très grand nombre de connexions, ce qui accélère la croissance de manière super-linéaire.

**p = 0.3** offre le meilleur compromis : clustering élevé sans explosion du degré moyen.

### 6.6 Évaluation du modèle par copie

**Avantages** :
-  Clustering **beaucoup plus élevé** que Barabási-Albert
-  Se rapproche davantage des réseaux sociaux réels
-  Mécanisme intuitivement plausible (partage de contacts)

**Limitations** :
- Distribution des degrés pas parfaitement en loi de puissance
- Clustering encore inférieur à DBLP (0.48 vs 0.632)
- Degré moyen plus faible (4.97 vs 6.62)
- Compromis nécessaire via le paramètre p

**Pistes d'amélioration** :
Pour mieux modéliser DBLP, un modèle hybride pourrait combiner :
- Attachement préférentiel (loi de puissance)
- Mécanisme de copie (clustering)
- Structure en communautés explicite (modularité)

---

## Synthèse Partie 1

### Caractéristiques identifiées du réseau DBLP

Le réseau de collaboration DBLP présente toutes les signatures d'un **réseau social complexe** :

| Propriété | Valeur mesurée | Classification |
|-----------|----------------|----------------|
| Distribution des degrés | Loi de puissance (γ = 2.7) | **Réseau sans échelle** |
| Clustering | 0.632 (30,000× réseau aléatoire) | **Forte transitivité** |
| Distance moyenne | 6.8 | **Réseau petit monde** |
| Connexité | 1 composante | **Réseau connexe** |
| Diamètre | ~20-25 | **Communication efficace** |

### Mécanismes de formation du réseau

Les propriétés observées suggèrent plusieurs processus sociaux sous-jacents :

1. **Attachement préférentiel** : Les auteurs prolifiques attirent plus de nouvelles collaborations (mécanisme du "riche devient plus riche" → loi de puissance)

2. **Fermeture triadique** : Si deux chercheurs A et B collaborent avec C, ils ont une forte probabilité de collaborer ensemble (→ clustering élevé)

3. **Homophilie thématique** : Les chercheurs travaillant sur des sujets similaires collaborent plus facilement (→ structure en communautés)

4. **Contraintes géographiques et institutionnelles** : Proximité physique ou affiliation à la même institution favorise les collaborations

### Implications scientifiques

**Pour la science des réseaux** :
- Les modèles simples (aléatoire, attachement préférentiel pur) sont insuffisants
- Les réseaux sociaux nécessitent des mécanismes multiples et synergiques
- Le clustering élevé est une signature des interactions sociales humaines

**Pour la sociologie de la science** :
- Le réseau DBLP révèle la structure de la recherche en informatique
- Existence de communautés thématiques et de chercheurs "hubs" centraux
- Les collaborations ne sont pas aléatoires mais structurées socialement

**Universalité des propriétés** :
Ces caractéristiques (loi de puissance, petit monde, clustering) se retrouvent dans de nombreux réseaux : réseaux sociaux en ligne, réseaux biologiques, Internet, réseaux de transport, etc.

---

# PARTIE 2 : Dynamique de Propagation Virale

Après avoir caractérisé la structure statique du réseau DBLP, nous étudions maintenant sa **dynamique** : comment un virus informatique se propage-t-il dans ce réseau? Quelles stratégies d'immunisation sont efficaces?

### Contexte et hypothèses

**Scénario** : Un virus informatique se propage par email entre collaborateurs scientifiques.

**Modèle épidémiologique** : SIS (Susceptible-Infected-Susceptible)
- Les individus passent de l'état **Susceptible** (sain) à **Infecté**
- Après nettoyage, ils redeviennent **Susceptibles** (pas d'immunité permanente)
- Modèle réaliste pour les virus informatiques (réinfections possibles)

**Paramètres** :
- **β (transmission)** : Un individu envoie 1 mail/semaine à ses collaborateurs → β = 1/7 ≈ 0.143 par jour
- **γ (récupération)** : Mise à jour antivirus 2×/mois → γ = 2/30 ≈ 0.067 par jour
- **R0 (taux de reproduction)** : R0 = β/γ = (1/7) / (2/30) ≈ **2.14**

**Interprétation de R0** : Chaque individu infecté transmet en moyenne le virus à 2.14 autres personnes. Puisque R0 > 1, une épidémie peut théoriquement se développer.

---

## 1. Seuils Épidémiques et Théorie de Percolation

### 1.1 Seuil épidémique du réseau DBLP

Le **seuil épidémique** τ caractérise la capacité d'un réseau à propager une épidémie. Pour les réseaux hétérogènes (avec distribution de degrés large), il est calculé par :

**τ = <k²>/<k> - 1**

où:
- <k> : degré moyen
- <k²> : second moment de la distribution des degrés

**Résultats pour DBLP** :
- <k> = 6.62
- <k²> ≈ 110.5
- **τ = 15.69**

**Comparaison avec R0** :
- R0 = 2.14
- τ = 15.69
- **R0 << τ**

**Interprétation paradoxale** : Selon la théorie de percolation, l'épidémie **ne devrait pas** se propager car R0 < τ. Cependant, le modèle SIS avec dynamique temporelle peut exhiber des comportements différents (phases transitoires, fluctuations locales).

### 1.2 Comparaison avec un réseau aléatoire

Pour un réseau aléatoire de même degré moyen :
- τ_aléatoire = <k> = 6.62

**Ratio** : τ_DBLP / τ_aléatoire = 15.69 / 6.62 = **2.37×**

**Explication** :
- Le réseau DBLP a un seuil épidémique **2.37× plus élevé** qu'un réseau aléatoire
- Cause : La **loi de puissance** et les **hubs** augmentent fortement <k²>
- **Conséquence duale** :
  - Épidémie plus **difficile à démarrer** (seuil élevé)
  - Mais une fois les hubs infectés, propagation **très rapide**

---

## 2. Simulation des Scénarios d'Intervention

### 2.1 Protocole expérimental

Nous comparons trois stratégies de contrôle épidémique :

**Scénario 0 : Aucune intervention**
- Propagation naturelle du virus
- 0% d'immunisés
- Scénario de référence

**Scénario 1 : Immunisation aléatoire (50%)**
- 50% des individus choisis aléatoirement maintiennent leur antivirus à jour en permanence
- ~158,540 nœuds immunisés
- Distribution uniforme dans le réseau

**Scénario 2 : Immunisation sélective par acquaintance (50%)**
- 50% des individus convainquent un de leurs voisins aléatoire de s'immuniser
- Exploite le **paradoxe de l'amitié** : les voisins ont en moyenne plus de connexions
- Cible préférentiellement les **hubs** sans les connaître explicitement

**Méthodologie** :
- **10 simulations** indépendantes par scénario (moyenne pour réduire la variance stochastique)
- Durée : **90 jours** (3 mois)
- Patient zéro : individu aléatoire parmi les non-immunisés
- Réseau DBLP complet (317,080 nœuds)

### 2.2 Résultats comparatifs

| Scénario | Pic d'infection | Jour du pic | Fraction max | Réduction vs Scénario 0 |
|----------|-----------------|-------------|--------------|-------------------------|
| 0: Aucune intervention | ~260,000 | 80 | 82.0% | - |
| 1: Immunisation aléatoire | ~59,000 | 88 | 37.1% | **54.7%** |
| 2: Immunisation sélective | ~3,200 | 90 | 1.5% | **98.2%** |

![Comparaison scénarios](output/images/partie2_epidemic_scenarios.png)

### 2.3 Analyse des résultats

**Sans intervention (Scénario 0)** :
- L'épidémie atteint **82% de la population** (260,000 infectés au pic)
- Pic au jour 80, infection massive du réseau
- Confirmé : R0 = 2.14 > 1 permet une épidémie majeure dans ce réseau scale-free

**Immunisation aléatoire (Scénario 1)** :
- Réduit le pic de **54.7%** (260,000 → 59,000)
- Immunisation de 50% de la population (158,540 nœuds)
- Efficacité modérée : la moitié des nœuds immunisés "gaspillée" sur des nœuds peu connectés
- Pic retardé au jour 88 (vs jour 80 sans intervention)

**Immunisation sélective (Scénario 2)** :
- Réduit le pic de **98.2%** (260,000 → 3,200)
- Immunisation de seulement 32% de la population (101,794 nœuds) grâce au ciblage intelligent
- **Efficacité spectaculaire** : **25× plus efficace** que l'aléatoire (37.1% → 1.5%)!
- Pic au jour 90, épidémie quasi-supprimée
- Moins d'immunisés (32% vs 50%) mais résultat radicalement supérieur

**Conclusion clé** : La **topologie du réseau** détermine l'efficacité des stratégies. L'immunisation sélective exploite intelligemment la structure hétérogène (hubs) du réseau.

---

## 3. Paradoxe de l'Amitié et Efficacité de l'Immunisation Sélective

### 3.1 Analyse des degrés moyens par groupe

| Stratégie | Groupe | Degré moyen | Écart vs moyenne globale |
|-----------|--------|-------------|--------------------------|
| Aléatoire | Immunisés | 6.62 | 0% |
| Aléatoire | Non-immunisés | 6.62 | 0% |
| **Sélective** | **Immunisés** | **9.5** | **+43%** |
| **Sélective** | **Non-immunisés** | **3.8** | **-43%** |

### 3.2 Le paradoxe de l'amitié

**Énoncé** : "En moyenne, vos amis ont plus d'amis que vous"

**Explication mathématique** :
- Un nœud de degré k apparaît k fois comme voisin
- Les nœuds à **haut degré** ont plus de chances d'être choisis comme voisins
- Conséquence : La moyenne des degrés des voisins est supérieure à la moyenne des degrés

**Mécanisme de l'immunisation acquaintance** :
1. Sélectionner 50% des nœuds aléatoirement
2. Chacun choisit un voisin aléatoire à immuniser
3. Les **hubs** (super-connecteurs) ont beaucoup de voisins
4. Ils ont donc plus de chances d'être choisis par quelqu'un
5. Résultat : Les immunisés ont un degré moyen **43% plus élevé** (9.5 vs 6.62)

**Conséquences épidémiologiques** :
- Les **super-spreaders** (hubs) sont neutralisés
- Les nœuds restants (susceptibles) sont peu connectés (degré 3.8)
- La propagation est **fortement ralentie**
- Même fraction immunisée, efficacité **radicalement supérieure**

### 3.3 Modification des seuils épidémiques

L'immunisation équivaut à **supprimer** des nœuds du réseau. Calculons les nouveaux seuils :

| Configuration | Seuil épidémique τ | Variation | R0/τ |
|---------------|-------------------|-----------|------|
| Réseau original | 15.69 | - | 0.14 |
| Après immunisation aléatoire | 8.2 | -48% | 0.26 |
| Après immunisation sélective | 22.5 | **+44%** | **0.10** |

**Interprétation** :

**Immunisation aléatoire** :
- **Diminue** le seuil (15.69 → 8.2)
- Supprime des nœuds uniformément → réduit <k> et <k²> proportionnellement
- Rend l'épidémie **plus facile** à se propager (R0/τ augmente)
- Paradoxe apparent résolu : réduction du pic due à la diminution de la population susceptible, pas à l'augmentation du seuil

**Immunisation sélective** :
- **Augmente** le seuil (15.69 → 22.5)
- Supprime préférentiellement les hubs → réduit <k²> beaucoup plus que <k>
- Rend l'épidémie **plus difficile** à se propager (R0/τ diminue)
- Double bénéfice : réduction de la population susceptible ET augmentation de la résistance structurelle

---

## 4. Influence de la Topologie sur la Dynamique Épidémique

### 4.1 Réseaux testés

Pour comprendre le rôle de la topologie, nous simulons l'épidémie sur trois types de réseaux de même taille (N = 50,000) et degré moyen (<k> ≈ 6.62) :

1. **DBLP (échantillon)** : Loi de puissance + clustering élevé (C ≈ 0.63)
2. **Erdős-Rényi** : Distribution homogène (Poisson) + clustering quasi-nul (C ≈ 0.0001)
3. **Barabási-Albert** : Loi de puissance + clustering faible (C ≈ 0.005)

### 4.2 Résultats : Scénario 0 (aucune intervention)

| Réseau | Clustering | Pic infection (fraction) | Jour pic | Vitesse | Comportement |
|--------|-----------|--------------------------|----------|---------|--------------|
| DBLP | 0.632 | **65.6%** | 90 | **Modérée** | Clustering ralentit |
| Erdős-Rényi | 0.00013 | **87.9%** | 73 | **Moyenne** | Propagation homogène |
| Barabási-Albert | 0.005 | **54.9%** | 71 | **Rapide initialement** | Hubs accélèrent |

![Comparaison réseaux - Scénario 0](output/images/partie2_epidemic_networks.png)

### 4.3 Comparaison des trois scénarios par réseau

**Réseau DBLP** :
![DBLP scénarios](output/images/partie2_DBLP_scenarios.png)

**Réseau Erdős-Rényi** :
![Random scénarios](output/images/partie2_Random_scenarios.png)

**Réseau Barabási-Albert** :
![BA scénarios](output/images/partie2_BA_scenarios.png)

### 4.4 Analyse comparative approfondie

**Réseau Erdős-Rényi (aléatoire)** :
- **Pic le plus élevé** : **87.9%** de la population (jour 73)
- Distribution homogène des degrés → pas de super-spreaders
- Tous les nœuds sont "moyens" → propagation diffuse et uniforme
- Malgré absence de hubs, l'épidémie atteint la majorité de la population
- **Efficacité des immunisations** : Les deux stratégies (aléatoire/sélective) ont une efficacité similaire car il n'y a pas de hubs à cibler

**Réseau Barabási-Albert** :
- **Pic d'infection** : **54.9%** de la population (jour 71)
- **Pic le plus bas** des trois réseaux malgré les hubs
- Présence de hubs → accélère la propagation initiale
- Clustering **très faible** (0.005) → pas de redondance, chaque lien est critique
- Les hubs agissent comme des "autoroutes" pour le virus
- **Efficacité des immunisations** : L'immunisation sélective est **extrêmement efficace** car elle neutralise les hubs

**Réseau DBLP** :
- **Pic d'infection** : **65.6%** de la population (jour 90)
- **Comportement intermédiaire** entre Random et BA
- **Structure complexe** : Hubs (accélèrent) + Clustering élevé (ralentit)
- Le **clustering crée de la redondance** : beaucoup de voisins d'un nœud sont déjà connectés entre eux
- Les triangles "piègent" localement le virus → ralentissent la propagation globale
- Malgré les hubs (loi de puissance), le clustering limite l'impact des super-spreaders
- Pic plus tardif (jour 90) que les autres réseaux grâce au clustering
- **Efficacité des immunisations** : L'immunisation sélective reste très efficace (98.2% de réduction)

### 4.5 Rôle du clustering

**Observation clé** : À structure de degrés comparable (loi de puissance), le clustering **ralentit** la propagation.

**Mécanisme** :
- Dans un réseau avec clustering élevé, beaucoup de voisins d'un nœud infecté sont déjà connectés
- Quand le virus atteint ces voisins, ils ne peuvent pas le transmettre à de "nouveaux" nœuds (ils partagent les mêmes contacts)
- Les triangles créent une "redondance" qui limite l'expansion géographique du virus
- Contraste avec BA : chaque lien ouvre potentiellement une nouvelle zone du réseau

**Implication** : Le clustering est une **barrière naturelle** aux épidémies, même dans les réseaux à loi de puissance.

---

## Synthèse Partie 2

### Résultats majeurs

| Aspect | Résultat clé | Valeur |
|--------|-------------|--------|
| Seuil épidémique DBLP | τ vs réseau aléatoire | **2.37× plus élevé** |
| Efficacité immunisation sélective | vs aléatoire | **25× plus efficace** (37.1% → 1.5%) |
| Réduction pic (sélective vs aucune) | Scénario 2 vs 0 | **98.2%** (260k → 3.2k) |
| Paradoxe de l'amitié | Degré immunisés sélectifs | **+43% vs moyenne** (9.5 vs 6.62) |
| Impact clustering | Propagation DBLP vs Random | Pic plus tardif (jour 90 vs 73) |
| Modification du seuil | Immunisation sélective | **+44% (15.69 → 22.5)** |

### Recommandations pour le contrôle épidémique

**Stratégies efficaces** :

1. **Priorité absolue** : Cibler les **hubs** (centres névralgiques du réseau)
   - Immunisation sélective (acquaintance) : simple et très efficace
   - Immunisation directe des hubs si on les connaît : encore plus efficace

2. **Exploiter la structure** :
   - Identifier les communautés et immuniser les "ponts" entre elles
   - Utiliser le clustering naturel comme barrière complémentaire

3. **Surveiller les hubs** :
   - En cas d'épidémie, tester prioritairement les nœuds à haut degré
   - Isoler rapidement les super-spreaders infectés

**Stratégies à éviter** :

1. **Immunisation purement aléatoire** : Inefficace sur réseaux hétérogènes (gaspillage de ressources)

2. **Ignorer la topologie** : Traiter tous les individus également est sous-optimal

### Enseignements théoriques

**1. La structure détermine la dynamique** :
- Même R0, même <k>, mais topologies différentes → dynamiques radicalement différentes
- Hubs : accélérateurs de propagation
- Clustering : frein à la propagation

**2. Optimisation des interventions** :
- Dans un réseau homogène (aléatoire) : immunisation aléatoire acceptable
- Dans un réseau hétérogène (loi de puissance) : cibler les hubs est **crucial**
- Le paradoxe de l'amitié offre une heuristique simple et puissante

**3. Dualité du seuil épidémique** :
- Seuil élevé : épidémie difficile à démarrer
- Mais une fois démarrée (hubs infectés), propagation très rapide
- Nécessité d'interventions **précoces** et **ciblées**

### Implications pratiques

**Pour la cybersécurité** :
- Surveiller les nœuds les plus connectés (serveurs centraux, utilisateurs avec beaucoup de contacts)
- Déployer les mises à jour en priorité sur les hubs
- Architecture réseau : éviter les "single points of failure" à haut degré

**Pour la santé publique** :
- Identifier les super-spreaders potentiels (métiers à risque, forte sociabilité)
- Stratégies de vaccination ciblées selon la structure sociale
- Quarantaine prioritaire des individus très connectés

**Pour la diffusion d'information** :
- Marketing viral : cibler les influenceurs (hubs sociaux)
- Fact-checking : corriger prioritairement les sources à large audience
- Innovation : les nouvelles idées se propagent via les hubs

---

# Conclusions Générales

## Synthèse de l'Analyse Complète

Ce travail a permis de caractériser exhaustivement le réseau de collaboration DBLP sous deux angles complémentaires :

### Structure statique (Partie 1)

Le réseau DBLP est un **réseau social complexe** exhibant simultanément :

1. **Propriété sans échelle** (scale-free)
   - Distribution des degrés en loi de puissance : p_k ∝ k^(-2.7)
   - Présence de hubs (auteurs très prolifiques)
   - Hétérogénéité forte des connectivités

2. **Propriété petit monde** (small-world)
   - Distance moyenne courte : 6.8 (confirmation des "six degrés")
   - Clustering élevé : 0.632 (30,000× réseau aléatoire)
   - Efficacité de communication + robustesse locale

3. **Structure en communautés**
   - Transitivité élevée des collaborations
   - Groupes de recherche densément connectés
   - Hiérarchie thématique implicite

### Dynamique épidémique (Partie 2)

La propagation virale dans le réseau DBLP révèle :

1. **Seuil épidémique élevé** (τ = 15.69)
   - 2.37× supérieur à un réseau aléatoire
   - Dû à l'hétérogénéité (loi de puissance)
   - Épidémie difficile à démarrer mais rapide si lancée

2. **Efficacité différentielle des interventions**
   - Immunisation aléatoire : réduction de 54.7% (82% → 37.1%)
   - Immunisation sélective : réduction de 98.2% (82% → 1.5%) (**25× plus efficace**)
   - Le paradoxe de l'amitié permet de cibler les hubs sans les connaître
   - Avec seulement 32% d'immunisés ciblés, surpasse 50% d'immunisés aléatoires

3. **Rôle dual du clustering**
   - Augmente la distance effective (sortir des communautés)
   - Ralentit la propagation épidémique (redondance locale)
   - Contraste avec les modèles sans clustering (Barabási-Albert)

## Mécanismes Sous-Jacents

Les propriétés observées s'expliquent par plusieurs processus sociologiques :

| Mécanisme | Propriété induite | Évidence |
|-----------|-------------------|----------|
| **Attachement préférentiel** | Loi de puissance | Distribution des degrés en k^(-2.7) |
| **Fermeture triadique** | Clustering élevé | C = 0.632 vs 0.00002 (aléatoire) |
| **Homophilie thématique** | Structure en communautés | Groupes de recherche denses |
| **Contraintes spatiales** | Distance moyenne modérée | 6.8 vs 6.5 (aléatoire) |

## Limites des Modèles Théoriques

| Modèle | Reproduit | Ne reproduit pas | Verdict |
|--------|-----------|------------------|---------|
| Erdős-Rényi | Distances courtes | Loi de puissance, clustering | ❌ Inadéquat |
| Barabási-Albert | Loi de puissance, distances | Clustering élevé | ⚠️ Insuffisant |
| Copie | Loi de puissance, clustering partiel | Clustering complet, degré |  Amélioration |
| **DBLP réel** | **Toutes propriétés** | - |  Complexité authentique |

**Leçon fondamentale** : Les réseaux sociaux réels ne peuvent être capturés par un mécanisme unique. Ils nécessitent des modèles **multi-mécanismes** combinant :
- Attachement préférentiel (hétérogénéité)
- Formation de triangles (clustering)
- Structure en communautés (modularité)
- Contraintes exogènes (géographie, institutions)

## Implications Interdisciplinaires

### Pour la science des réseaux
- Nécessité de modèles génératifs plus sophistiqués
- Importance de mesurer **plusieurs** propriétés simultanément
- Les réseaux sociaux sont **plus** que la somme de leurs mécanismes

### Pour la sociologie de la science
- La recherche s'organise en communautés thématiques
- Existence de chercheurs centraux ("gatekeepers")
- Les collaborations suivent des logiques sociales, pas aléatoires

### Pour l'épidémiologie et la cybersécurité
- Les stratégies d'intervention doivent être **topologiquement informées**
- Cibler les hubs est crucial dans les réseaux hétérogènes
- Le clustering est une barrière naturelle (mais pas suffisante)

### Universalité
Ces propriétés transcendent le réseau DBLP et se retrouvent dans :
- Réseaux sociaux en ligne (Facebook, Twitter, LinkedIn)
- Réseaux biologiques (interactions protéines, réseaux neuronaux)
- Réseaux technologiques (Internet, réseau électrique)
- Réseaux économiques (commerce, finance)

## Perspectives et Extensions

### Améliorations méthodologiques
- Analyse temporelle : évolution du réseau DBLP au fil du temps
- Détection de communautés : identifier les sous-domaines thématiques
- Centralité multiple : PageRank, betweenness, closeness

### Extensions des simulations épidémiques
- Modèles SEIR, SIRS avec période d'incubation
- Hétérogénéité des paramètres (β et γ variables)
- Stratégies d'immunisation dynamiques (adapter en cours d'épidémie)

### Comparaisons interdisciplinaires
- Confronter DBLP à d'autres réseaux scientifiques (PubMed, arXiv)
- Comparer avec des réseaux sociaux non-académiques
- Étudier les invariants universels et les spécificités

---

# Annexes Techniques

## Outils et Technologies

### Environnement de développement
- **Langage** : Java 11
- **Build** : Maven 3.6+
- **IDE** : IntelliJ IDEA / Eclipse / VS Code

### Bibliothèques principales
- **GraphStream 2.0** : Manipulation et analyse de graphes
  - Classes utilisées : `SingleGraph`, `FileSourceEdge`, `Toolkit`
  - Algorithmes : BFS, calcul de métriques, génération de réseaux
  - Documentation : [graphstream-project.org](https://graphstream-project.org/)

- **Apache Commons Math** : Statistiques et ajustements
  - Distribution de Poisson
  - Régression linéaire pour fits en log-log

### Visualisation
- **gnuplot 5.4+** : Génération de graphiques PNG
  - Échelles linéaires et logarithmiques
  - Fits de fonctions (loi de puissance)
  - Comparaisons multi-courbes

### Données
- **Source** : [SNAP Stanford - DBLP Collaboration Network](https://snap.stanford.edu/data/com-DBLP.html)
- **Format** : Liste d'arêtes (edge list)
- **Taille** : 317,080 nœuds, 1,049,866 arêtes
- **Prétraitement** : Aucun (données utilisées telles quelles)

---

## Instructions d'Exécution

### Prérequis
```bash
# Vérifier Java 11+
java -version

# Vérifier Maven
mvn -version

# Vérifier gnuplot
gnuplot --version
```

### Compilation du projet
```bash
cd /path/to/projet
mvn clean compile
```

### Exécution complète
```bash
# Lancer le menu interactif
mvn exec:java

# Le menu propose :
# PARTIE 1:
#  1. Charger le graphe DBLP
#  2. Mesures de base (degré moyen, clustering)
#  3. Connexité et seuil critique
#  4. Distribution des degrés
#  5. Distances moyennes (15-25 min)
#  6. Générateurs de réseaux (30-40 min)
#  7. BONUS: Générateur par copie (15-20 min)
#
# PARTIE 2:
#  9. Calcul des seuils épidémiques
# 10. Simulation 3 scénarios (5-10 min)
# 11. Analyse immunisation
# 12. Comparaison topologies (15-20 min)
# 13. Exécuter tout (Partie 2 complète)
#
#  0. Tout exécuter (Partie 1 + 2, ~2h)
```

### Génération des graphiques

**Partie 1** :
```bash
cd gnuplot

# Distribution des degrés
gnuplot plot_dd_linear.gnu
gnuplot plot_dd_loglog.gnu
gnuplot plot_dd_powerlaw.gnu
gnuplot plot_dd_comparison.gnu

# Distances
gnuplot plot_distances.gnu

# Comparaison réseaux
gnuplot plot_comparison_networks.gnu

# Clustering (bonus)
gnuplot plot_clustering_comparison.gnu
gnuplot plot_clustering_comparison_log.gnu
```

**Partie 2** :
```bash
cd gnuplot

# Script automatique (génère tous les graphiques)
./generate_all_partie2.sh

# Ou individuellement:
gnuplot plot_epidemic_scenarios.gnu
gnuplot plot_epidemic_networks.gnu
gnuplot plot_epidemic_detailed.gnu
gnuplot plot_epidemic_detailed_scenario1.gnu
gnuplot plot_epidemic_detailed_scenario2.gnu
gnuplot plot_DBLP_scenarios.gnu
gnuplot plot_Random_scenarios.gnu
gnuplot plot_BA_scenarios.gnu
```

### Temps d'exécution estimés

| Tâche | Durée | Commentaire |
|-------|-------|-------------|
| Chargement DBLP | ~30-60s | Parsing du fichier |
| Mesures de base | ~2-3 min | Degré moyen, clustering |
| Connexité | ~3-5 min | Recherche composantes |
| Distribution degrés | ~5 min | Parcours complet |
| **Distances moyennes** | **15-25 min** | 1000 BFS, très coûteux |
| **Générateurs** | **30-40 min** | Génération 3 réseaux |
| **Bonus copie** | **15-20 min** | Génération + analyse |
| Seuils épidémiques | ~2 min | Calculs analytiques |
| **Simulation 3 scénarios** | **5-10 min** | 30 simulations SIS |
| Analyse immunisation | ~3 min | Calculs degrés moyens |
| **Comparaison topologies** | **15-20 min** | 27 simulations (3 réseaux × 3 scénarios × 3 runs) |
| **TOTAL (sans bonus)** | **~1h30** | Exécution complète Partie 1 + 2 |

**Recommandation** : Exécuter les parties longues (distances, générateurs, comparaison topologies) séparément, idéalement en arrière-plan ou pendant les pauses.

---

## Structure du Code

### Architecture du projet
```
src/main/java/fr/univ/dblp/
├── Main.java                      # Menu interactif principal
├── analysis/
│   ├── BasicMetrics.java          # Degré moyen, clustering, connexité
│   ├── DegreeDistribution.java    # Distribution des degrés, fit loi de puissance
│   ├── DistanceCalculator.java    # BFS, distances moyennes
│   └── NetworkComparator.java     # Comparaison DBLP vs modèles
├── generators/
│   ├── RandomGraphGenerator.java  # Erdős-Rényi
│   ├── BAGraphGenerator.java      # Barabási-Albert
│   └── CopyGraphGenerator.java    # Générateur par copie (bonus)
├── simulation/
│   ├── ViralSimulator.java        # Moteur simulation SIS
│   ├── SimulationResult.java      # Stockage résultats simulation
│   ├── ImmunizationStrategy.java  # Stratégies (aléatoire, sélective, hubs)
│   ├── EpidemicAnalyzer.java      # Calcul seuils épidémiques
│   └── SimulationExporter.java    # Export données gnuplot
└── utils/
    └── DataExporter.java          # Export distributions, distances

gnuplot/
├── Partie 1:
│   ├── plot_dd_linear.gnu         # Distribution degrés échelle linéaire
│   ├── plot_dd_loglog.gnu         # Distribution degrés échelle log-log
│   ├── plot_dd_powerlaw.gnu       # Fit loi de puissance
│   ├── plot_dd_comparison.gnu     # Comparaison avec Poisson
│   ├── plot_distances.gnu         # Distribution des distances
│   ├── plot_comparison_networks.gnu  # Comparaison 3 réseaux
│   ├── plot_clustering_comparison.gnu       # Clustering modèles (linéaire)
│   └── plot_clustering_comparison_log.gnu   # Clustering modèles (log)
└── Partie 2:
    ├── generate_all_partie2.sh    # Script génération automatique
    ├── plot_epidemic_scenarios.gnu   # Comparaison 3 scénarios (DBLP)
    ├── plot_epidemic_networks.gnu    # Comparaison 3 réseaux (Scénario 0)
    ├── plot_epidemic_detailed.gnu    # Évolution S-I-R Scénario 0
    ├── plot_epidemic_detailed_scenario1.gnu  # S-I-R Scénario 1
    ├── plot_epidemic_detailed_scenario2.gnu  # S-I-R Scénario 2
    ├── plot_DBLP_scenarios.gnu       # Scénarios sur DBLP
    ├── plot_Random_scenarios.gnu     # Scénarios sur Erdős-Rényi
    └── plot_BA_scenarios.gnu         # Scénarios sur Barabási-Albert

output/
├── data/                          # Fichiers .dat exportés
│   ├── Partie 1:
│   │   ├── dd_dblp.dat
│   │   ├── dd_poisson.dat
│   │   ├── distances_dblp.dat
│   │   └── comparison_*.dat
│   └── Partie 2:
│       ├── partie2_scenarios_comparison.dat
│       ├── partie2_networks_comparison.dat
│       ├── partie2_Scenario_*.dat
│       ├── partie2_*_scenarios.dat
│       └── partie2_scenarios_summary.dat
└── images/                        # Graphiques PNG générés
    ├── Partie 1:
    │   ├── dd_dblp_*.png
    │   ├── distances_dblp.png
    │   ├── comparison_all_networks.png
    │   └── clustering_comparison*.png
    └── Partie 2:
        ├── partie2_epidemic_scenarios.png
        ├── partie2_epidemic_networks.png
        ├── partie2_epidemic_detailed_scenario*.png
        ├── partie2_DBLP_scenarios.png
        ├── partie2_Random_scenarios.png
        └── partie2_BA_scenarios.png
```

### Classes principales

**Partie 1** :
- `BasicMetrics` : Calcule degré moyen, clustering, connexité via GraphStream Toolkit
- `DegreeDistribution` : Histogramme des degrés, export, fit loi de puissance
- `DistanceCalculator` : BFS parallélisé (échantillonnage 1000 nœuds)
- `NetworkComparator` : Génère et compare DBLP avec Erdős-Rényi et Barabási-Albert

**Partie 2** :
- `ViralSimulator` : Implémente le modèle SIS avec paramètres β, γ
  - Gère les états Susceptible/Infecté/Immunisé
  - Simulation jour par jour avec processus stochastique
- `ImmunizationStrategy` : Trois stratégies statiques
  - `randomImmunization` : Sélection uniforme
  - `acquaintanceImmunization` : Paradoxe de l'amitié
  - `hubImmunization` : Ciblage direct des hubs (par degré)
- `EpidemicAnalyzer` : Calcul analytique de τ = <k²>/<k> - 1
- `SimulationExporter` : Export TSV pour gnuplot (Locale.US pour points décimaux)

---

## Références Scientifiques

### Articles fondamentaux

**Réseaux petit monde** :
- Watts, D. J., & Strogatz, S. H. (1998). *Collective dynamics of 'small-world' networks*. Nature, 393(6684), 440-442.
  - Définit les propriétés small-world (clustering élevé + courtes distances)
  - Introduit le modèle de "rewiring"

**Réseaux de collaboration scientifique** :
- Newman, M. E. J. (2001). *The structure of scientific collaboration networks*. PNAS, 98(2), 404-409.
  - Analyse structurelle de plusieurs réseaux scientifiques
  - Confirme loi de puissance et clustering élevé

**Épidémies dans les réseaux** :
- Pastor-Satorras, R., & Vespignani, A. (2001). *Epidemic Spreading in Scale-Free Networks*. Physical Review Letters, 86(14), 3200-3203.
  - Seuil épidémique dans les réseaux sans échelle : τ = <k²>/<k> - 1
  - Absence de seuil pour γ ≤ 3 (propagation toujours possible)

**Paradoxe de l'amitié** :
- Feld, S. L. (1991). *Why Your Friends Have More Friends Than You Do*. American Journal of Sociology, 96(6), 1464-1477.
  - Formulation originale du paradoxe de l'amitié
  - Applications aux réseaux sociaux

### Livres de référence

- Barabási, A.-L. (2016). *Network Science*. Cambridge University Press.
  - Approche pédagogique de la science des réseaux
  - Disponible gratuitement : [networksciencebook.com](http://networksciencebook.com/)

### Bases de données

- **SNAP** (Stanford Network Analysis Project) : [snap.stanford.edu](https://snap.stanford.edu/)
  - Collection de réseaux réels (sociaux, biologiques, web, etc.)
  - DBLP, Facebook, Twitter, Amazon, citations, etc.


### Outils et logiciels

- **GraphStream** : [graphstream-project.org](https://graphstream-project.org/)
  - Bibliothèque Java pour analyse et visualisation de graphes dynamiques
  - API claire, nombreux algorithmes implémentés

- **gnuplot** : [gnuplot.info](http://www.gnuplot.info/)
  - Outil de visualisation scriptable
  - Idéal pour génération automatique de graphiques


---

**Fin du rapport**

---

**Auteur** : Hamadou BA

**Cours** : Mesures de réseaux d'interaction

**Institution** : Université Le Havre Normandie


**Version** : 2.0
