# Script gnuplot pour visualiser les 3 scénarios pour chaque type de réseau
# Partie 2 - Question 6 - Visualisation complète

set terminal png size 2100,900 font "Arial,14"
set output '../output/images/partie2_scenarios_all_networks.png'

set multiplot layout 1,3 title "Comparaison des scénarios d'immunisation par topologie de réseau\n{/*0.8 Modèle SIS (β=1/7, γ=2/30, 90 jours)}" font "Arial,18"

# Couleurs communes
set style line 1 lc rgb '#E41A1C' lw 3  # Rouge - Scénario 0
set style line 2 lc rgb '#377EB8' lw 3  # Bleu - Scénario 1
set style line 3 lc rgb '#4DAF4A' lw 3  # Vert - Scénario 2

set grid
set xrange [0:90]
set yrange [0:1]
set xlabel "Temps (jours)" font "Arial,12"

# Graphique 1: DBLP
set title "Réseau DBLP\n{/*0.8 Loi de puissance, C≈0.63}" font "Arial,14"
set ylabel "Fraction d'infectés" font "Arial,12"
set key top right font "Arial,11"

plot '../output/data/partie2_DBLP_scenarios.dat' using 1:2 with lines ls 1 title "Aucune intervention", \
     '' using 1:3 with lines ls 2 title "50% aléatoire", \
     '' using 1:4 with lines ls 3 title "50% sélective"

# Graphique 2: Erdős-Rényi
set title "Réseau Erdős-Rényi\n{/*0.8 Aléatoire, C≈0.00002}" font "Arial,14"
unset ylabel

plot '../output/data/partie2_Random_scenarios.dat' using 1:2 with lines ls 1 title "Aucune intervention", \
     '' using 1:3 with lines ls 2 title "50% aléatoire", \
     '' using 1:4 with lines ls 3 title "50% sélective"

# Graphique 3: Barabási-Albert
set title "Réseau Barabási-Albert\n{/*0.8 Attach. préférentiel, C≈0.005}" font "Arial,14"

plot '../output/data/partie2_BA_scenarios.dat' using 1:2 with lines ls 1 title "Aucune intervention", \
     '' using 1:3 with lines ls 2 title "50% aléatoire", \
     '' using 1:4 with lines ls 3 title "50% sélective"

unset multiplot
print "Graphique généré: output/images/partie2_scenarios_all_networks.png"
