# Script gnuplot pour visualiser la comparaison des 3 scénarios d'immunisation
# Partie 2 - Questions 3-4

set terminal png size 1400,900 font "Arial,14"
set output 'output/images/partie2_epidemic_scenarios.png'

set title "Propagation virale - Comparaison des scénarios d'immunisation\n{/*0.8 Réseau DBLP - Modèle SIS (β=1/7, γ=2/30, 90 jours)}" font "Arial,16"
set xlabel "Temps (jours)" font "Arial,14"
set ylabel "Fraction d'infectés (population non-immunisée)" font "Arial,14"

set grid
set key top right font "Arial,12"

set xrange [0:90]
set yrange [0:*]

# Couleurs distinctes
set style line 1 lc rgb '#E41A1C' lw 3 pt 7 ps 0.5  # Rouge - Aucune intervention
set style line 2 lc rgb '#377EB8' lw 3 pt 7 ps 0.5  # Bleu - Immunisation aléatoire
set style line 3 lc rgb '#4DAF4A' lw 3 pt 7 ps 0.5  # Vert - Immunisation sélective

plot 'output/data/partie2_scenarios_comparison.dat' using 1:2 with lines ls 1 title "Scénario 0: Aucune intervention", \
     '' using 1:3 with lines ls 2 title "Scénario 1: 50% immunisation aléatoire", \
     '' using 1:4 with lines ls 3 title "Scénario 2: 50% immunisation sélective"

print "Graphique généré: output/images/partie2_epidemic_scenarios.png"
