#!/usr/bin/env gnuplot

# Script gnuplot pour comparer les coefficients de clustering
# des différents modèles de réseaux

set terminal png size 800,600 enhanced font 'Arial,12'
set output '../output/images/clustering_comparison.png'

set title "Comparaison des coefficients de clustering" font 'Arial,14'
set ylabel "Coefficient de clustering" font 'Arial,12'
set xlabel "Modèle de réseau" font 'Arial,12'

set style data histograms
set style fill solid 0.8 border -1
set boxwidth 0.8
set grid ytics

set yrange [0:0.7]
set format y "%.2f"

# Couleurs pour chaque modèle
set style line 1 lc rgb '#2E7D32' # Vert pour DBLP
set style line 2 lc rgb '#1976D2' # Bleu pour Copie
set style line 3 lc rgb '#FFA726' # Orange pour Barabási-Albert
set style line 4 lc rgb '#E53935' # Rouge pour Aléatoire

# Données à afficher
$data << EOD
"DBLP" 0.632
"Copie\n(p=0.3)" 0.48
"Barabási-\nAlbert" 0.005
"Aléatoire" 0.00002
EOD

plot $data using 2:xtic(1) notitle ls 1, \
     '' using 0:2:2 with labels offset 0,1 font 'Arial,10' notitle
