# Script gnuplot pour visualiser les 3 scénarios sur chaque type de réseau
# Génère 3 graphiques côte à côte

set terminal png size 2100,700 font "Arial,13"
set output '../output/images/partie2_all_scenarios_by_network.png'

set multiplot layout 1,3 title "Comparaison des stratégies d'immunisation par topologie de réseau" font "Arial,16"

# Couleurs communes pour les 3 scénarios
set style line 1 lc rgb '#E41A1C' lw 3  # Rouge - Scénario 0
set style line 2 lc rgb '#377EB8' lw 3  # Bleu - Scénario 1
set style line 3 lc rgb '#4DAF4A' lw 3  # Vert - Scénario 2

set grid
set xrange [0:90]
set yrange [0:1]
set xlabel "Temps (jours)" font "Arial,11"
set key top left font "Arial,10"

# Graphique 1: Réseau DBLP
set title "Réseau DBLP\n{/*0.8 Loi de puissance, C≈0.63}" font "Arial,14"
set ylabel "Fraction d'infectés" font "Arial,11"

plot '../output/data/partie2_DBLP_scenarios.dat' using 1:2 with lines ls 1 title "Aucune intervention", \
     '' using 1:3 with lines ls 2 title "50% aléatoire", \
     '' using 1:4 with lines ls 3 title "50% sélective"

# Graphique 2: Réseau Aléatoire (Erdős-Rényi)
set title "Réseau Erdős-Rényi\n{/*0.8 Aléatoire, C≈0.0001}" font "Arial,14"
unset ylabel

plot '../output/data/partie2_Random_scenarios.dat' using 1:2 with lines ls 1 title "Aucune intervention", \
     '' using 1:3 with lines ls 2 title "50% aléatoire", \
     '' using 1:4 with lines ls 3 title "50% sélective"

# Graphique 3: Réseau Barabási-Albert
set title "Réseau Barabási-Albert\n{/*0.8 Attachement préférentiel, C≈0.005}" font "Arial,14"

plot '../output/data/partie2_BA_scenarios.dat' using 1:2 with lines ls 1 title "Aucune intervention", \
     '' using 1:3 with lines ls 2 title "50% aléatoire", \
     '' using 1:4 with lines ls 3 title "50% sélective"

unset multiplot
print "Graphique généré: output/images/partie2_all_scenarios_by_network.png"
