#!/bin/bash
# Script pour générer tous les graphiques de la partie 2

echo "==================================================="
echo "Génération des graphiques - Partie 2"
echo "==================================================="

# Vérifier que gnuplot est installé
if ! command -v gnuplot &> /dev/null; then
    echo "ERREUR: gnuplot n'est pas installé!"
    echo "Installation: brew install gnuplot (macOS) ou apt-get install gnuplot (Linux)"
    exit 1
fi

# Vérifier que les fichiers de données existent
if [ ! -f "output/data/partie2_scenarios_comparison.dat" ]; then
    echo "ERREUR: Fichiers de données manquants!"
    echo "Veuillez d'abord exécuter les simulations (Option 10 ou 13 du menu)"
    exit 1
fi

echo ""
echo ">>> Génération: Comparaison scénarios d'immunisation"
gnuplot plot_epidemic_scenarios.gnu
echo "✓ Créé: output/images/partie2_epidemic_scenarios.png"

if [ -f "output/data/partie2_networks_comparison.dat" ]; then
    echo ""
    echo ">>> Génération: Comparaison topologies de réseaux"
    gnuplot plot_epidemic_networks.gnu
    echo "✓ Créé: output/images/partie2_epidemic_networks.png"
fi

if [ -f "output/data/partie2_Scenario_0_Aucune_intervention.dat" ]; then
    echo ""
    echo ">>> Génération: Évolution détaillée scénario 0"
    gnuplot plot_epidemic_detailed.gnu
    echo "✓ Créé: output/images/partie2_epidemic_detailed_scenario0.png"
fi

echo ""
echo "==================================================="
echo "Tous les graphiques ont été générés avec succès!"
echo "==================================================="
echo "Consultez le répertoire: output/images/"
