import React from 'react';
import ReactDOM from 'react-dom';
import { createStore, combineReducers, applyMiddleware } from 'redux';
import { Provider } from 'react-redux';
import thunk from 'redux-thunk';
import { reducer as form } from 'redux-form';
import { Route, Switch } from 'react-router-dom';
import createBrowserHistory from 'history/createBrowserHistory';
import {
  ConnectedRouter,
  connectRouter,
  routerMiddleware
} from 'connected-react-router';
import 'bootstrap/dist/css/bootstrap.css';
import 'font-awesome/css/font-awesome.css';
import * as serviceWorker from './serviceWorker';

import BarChart from './components/BarChart';
import LineChart from './components/LineChart';
import Donut from './components/Donut';

// Import your reducers and routes here
import Welcome from './Welcome';
import Homepage from './homepage';

// import reducers
import propertysale from './reducers/propertysale';

//import routes
import propertySaleRoutes from './routes/propertysale';

const history = createBrowserHistory();
const store = createStore(
  combineReducers({
    router: connectRouter(history),
    form,
    propertysale,
  }),
  applyMiddleware(routerMiddleware(history), thunk)
);

ReactDOM.render(
  <Provider store={store}>
    <ConnectedRouter history={history}>
      <Switch>
        <Route path="/" component={Homepage} strict={true} exact={true} />
        <Route path="/welcome" component={Welcome} strict={true} exact={true} />
        <Route path="/barchart" component={BarChart} strict={true} exact={true} />
        <Route path="/linechart" component={LineChart} strict={true} exact={true} />
        <Route path="/donut" component={Donut} strict={true} exact={true} />
        {propertySaleRoutes}
        <Route render={() => <h1>Not Found</h1>} />
      </Switch>
    </ConnectedRouter>
  </Provider>,
  document.getElementById('root')
);

// If you want your app to work offline and load faster, you can change
// unregister() to register() below. Note this comes with some pitfalls.
// Learn more about service workers: http://bit.ly/CRA-PWA
serviceWorker.unregister();
