import React, { Component } from 'react';
import * as d3 from 'd3';

class LineChart extends Component {

    componentDidMount() {
        this.drawChart();
    }

    componentDidUpdate() {
        this.drawChart();
    }

    // - - - - - - - - - - - 
    drawChart() {
        const data = [
            { date: "10/25/2018", value: 1 },
            { date: "10/26/2018", value: 3 },
            { date: "10/27/2018", value: 0 },
            { date: "10/28/2018", value: 0 },
            { date: "10/29/2018", value: 5 },
            { date: "10/30/2018", value: 8 },
            { date: "10/31/2018", value: 7 },
            { date: "11/01/2018", value: 11 },
            { date: "11/02/2018", value: 23 },
            { date: "11/03/2018", value: 13 },
            { date: "11/04/2018", value: 15 },
            { date: "11/05/2018", value: 37 },
            { date: "11/06/2018", value: 32 },
            { date: "11/07/2018", value: 38 },
            { date: "11/08/2018", value: 42 },
            { date: "11/09/2018", value: 43 },
            { date: "11/10/2018", value: 21 },
            { date: "11/11/2018", value: 24 },
            { date: "11/12/2018", value: 50 },
            { date: "11/13/2018", value: 53 },
            { date: "11/14/2018", value: 59 },
            { date: "11/15/2018", value: 61 },
            { date: "11/16/2018", value: 62 }
        ];


        const margin = { top: 50, right: 40, bottom: 10, left: 100 };
        const padding = { top: 10, right: 10, bottom: 10, left: 10 };
        const x = 800;
        const y = 600;
        const width = 20 + x - margin.right - margin.left;
        const height = padding.top + padding.right + padding.bottom + padding.left + y + margin.top + margin.bottom;

        // Line generator.
        const line = d3
            .line()
            .x((d) => xScale(d.date))
            .y((d) => yScale(d.value))
            .curve(d3.curveMonotoneX);

        var parseTime = d3.timeParse("%m/%d/%Y");

        data.forEach(function(d) {
            d.date = parseTime(d.date);
        });

        const xScale = d3
            .scaleTime()
            .domain(d3.extent(data, function(d) { return d.date; }))
            .range([0, width]);

        const yScale = d3
            .scaleLinear()
            .domain(d3.extent(data, function(d) { return d.value }))
            .range([height, 0]);

        // - - - - - - - - - - - 
        // Main SVG
        const svg = d3.select("#app")
            .append("svg")
            .attr("width", width + 100)
            .attr("height", height + 100)
            .style("margin-top", margin.top)
            .style("margin-left", margin.left)
            .style("border", "1px solid black")
            .append('g')
            .attr('transform', `translate(${margin.left}, ${margin.top})`);

        const xAxis = d3.axisBottom(xScale)
            .tickSizeOuter(0)
            .tickFormat(d3.timeFormat("%d %m %Y"));

        const xAxisDraw = svg
            .append('g')
            .attr('transform', `translate(0, ${height})`)
            .attr('class', 'x axis')
            .call(xAxis);
        
        // Draw y axis.
        const yAxis = d3
            .axisLeft(yScale)
            .ticks(3)
            .tickSizeOuter(0)
            .tickSizeInner(-width);

        const yAxisDraw = svg
            .append('g')
            .attr('class', 'y axis')
            .style("color", "#999")
            .call(yAxis);

        const chartGroup = svg.append('g').attr('class', 'line-chart');

        // - - - - - - - - - - - 
        svg.append("path")
            .data([data])
            .attr("class", "line")
            .attr("fill", "none")
            .attr("stroke", "red")
            .attr("d", line)


        // - - - - - - - - - - - 
        // Draw header.
        const header = svg
            .append('g')
            .attr('class', 'line-chart-header')
            .attr('transform', `translate(${width / 2 }, ${0})`)
            .append('text');

        header.append('tspan').text('Prix Moyen du M²');

        const yLabel = svg
            .append('g')
            .attr('class', 'yLabel')
            .attr('transform', `translate(${ -80 },${height / 2})`)
            .append('text')
            .attr('dy', '1em')
            .style('font-size', '2.0em')
            .style('fill', '#555')
            .text('K€');


        svg.exit().remove()
    }

    render() {
        return <div id = { 'app' } > </div>
    }
}

export default LineChart;