import React, { Component } from 'react';
import * as d3 from 'd3';

class BarChart extends Component {

    componentDidMount() {
        this.drawChart();
    }

    componentDidUpdate() {
        this.drawChart();
    }


    drawChart() {
        const data = [12, 5, 6, 6, 9, 10, 20, 10,20,34,11,21];
        // const data = this.props.data;
        const margin = {top:100, right: 40, bottom: 100, left: 100};
        const x = 400;
        const y = 500;
        const width = 200 + x + margin.left;
        const height = y + margin.top;

        var xScale = d3.scaleLinear()
            .domain([1, data.length + 1])
            .range([0, x ]);

        var yScale = d3.scaleLinear()
            .domain([0, d3.max(data)])
            .range([y - margin.top, 0]);

        // Add scales to axis
        var x_axis = d3.axisBottom()
            .scale(xScale)
            .ticks(12)
            .tickFormat(d3.format("d"))
            .tickSizeInner(5)
            .tickSizeOuter(5)
            .tickPadding(10)

        var y_axis = d3.axisLeft()
            .scale(yScale)
            .tickFormat(d3.format("d"))
            .ticks(5)

        const svg = d3.select("#app")
            .append("svg")
            .attr("width", width)
            .attr("height", height)
            .style("margin-top", margin.top)
            .style("margin-left", margin.left)
            .style("border", "1px solid black");

        // - - - - - - - - - - - 
        // Draw header
        const header = svg
            .append('g')
            .attr('class', 'bar-header')
            .attr('transform', `translate(${margin.left + (width / 2)},${-1 * 0.6})`)
            .append('text');

        header
            .append('tspan')
            .attr('x', 0)
            .attr('dy', '1.5em')
            .style('font-size', '0.8em')
            .style('fill', '#555')
            .text('Mois');

        // - - - - - - - - - - - 
        const x_axis_label = svg
            .append('g')
            .attr('class', 'bar-x-axis-label')
            .attr('transform', `translate(${margin.left + (width / 2) - 100}, ${520})`)
            .append('text');

        x_axis_label
            .append('tspan')
            .attr('x', 0)
            .attr('dy', '1.5em')
            .style('font-size', '0.8em')
            .style('fill', '#555')
            .text(`Mois de l'année`);
        
        const y_axis_label = svg
            .append('g')
            .attr('class', 'bar-yLegend')
            .attr('transform', `translate(${ 0 },${200})`)
            .append('text');

        y_axis_label
            .append('tspan')
            .attr('x', 15)
            .attr('dy', '1.5em')
            .style('font-size', '0.8em')
            .style('fill', '#555')
            .text('Nombre de');
        
        y_axis_label
            .append('tspan')
            .attr('x', 28)
            .attr('dy', '1.5em')
            .style('font-size', '0.8em')
            .style('fill', '#555')
            .text('Ventes');

        svg.append("g")
            .attr("transform", `translate(${margin.left}, ${500})`)
            .call(x_axis);

        svg.append("g")
            .attr("transform", `translate(${margin.left}, ${margin.top})`)
            .call(y_axis);


        // - - - - - - - - - - - 
        svg.selectAll("rect")
            .data(data)
            .enter()
            .append("rect")
            .attr("x", (d, i) => 1 * i * (x / data.length) )
            .attr("y", (d, i) => height - 10 * d)
            .attr("width", 27)
            .attr("height", (d, i) => d * 10)
            .attr("fill", '#b5a')
            .attr("transform", `translate(${margin.left}, ${-margin.top})`)

        svg.selectAll("text")
            .data(data)
            .enter()
            .append("text")
            .text((d) => d)
            .attr("x", (d, i) => i * 70)
            .attr("y", (d, i) => height - (10 * d) - 3)


        svg.exit().remove()            
    }

    render() {
        return <div id = {'app'} ></div>
    }
}

export default BarChart;