<?php
namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiResource;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * A property sale entity.
 *
 * @ORM\Entity
 * @ApiResource
 */
class PropertySale
{
    /**
     * @var int The id of this book.
     *
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var float The price of the property
     * 
     * @ORM\Column(type="float")
     */
    public $price;

    /**
     * @var int The surface of the property, in square meters
     * 
     * @ORM\Column(type="integer")
     * @Assert\NotNull
     */
    public $surface;

    /**
     * @var \DateTimeInterface The sale date.
     *
     * @ORM\Column(type="datetime")
     * @Assert\NotNull
     */
    public $date;

    /**
     * @var string The property's department.
     * 
     * @ORM\Column(type="text")
     * @Assert\NotBlank
     */
    public $department;

    /**
     * @var string The property's region.
     * 
     * @ORM\Column(type="text")
     * @Assert\NotBlank
     */
    public $region;
    
    public function __construct()
    {
    }

    public function getId(): ?int
    {
        return $this->id;
    }
}
?>