<?php 
// si il vous manque des fichiers, pensez à mettre les fichiers valeursfoncières-*.txt dans le dossier DataFixture
namespace App\DataFixtures;

use App\Entity\PropertySale;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use \DateTime;

class AppFixtures extends Fixture
{


    public function load(ObjectManager $manager)
    {
        echo __DIR__;
        // create 20 products! Bam!
        for($annee = 2015;$annee<=2015;$annee++){
            echo "chargement des données de l'année ".$annee."\n\n";
            $json = file_get_contents(__DIR__.'/deps.json');
            $deps = json_decode($json,true);
            $file = fopen(__DIR__."/valeursfoncieres-".$annee.".txt","r");      
            $cpt = 1;
            $nbelt = 43;
            $percent = 0;
            $line = fgetcsv($file,1024,"|");//enleve la premiere ligne contenant le descriptif des ventes
    
            $depToRegion = array();
            foreach ($deps as $key => $value) {
                echo $value["nom"];
                $depToRegion[$value["code"]] = $value["nomRegion"];
            };

            while(!feof($file)){
                
                $line = fgetcsv($file,1024,"|");
                    // on ne prend en compte que les ventes, tout autre élément est ignoré car l'evenement peut influer sur le prix
                    // puisque le nombre de vente est tres supérieur aux autre type de mutation le résultat n'en sera affecté que de façon négligeable
                    //if(strcmp($line[9],'Vente')==0 &&( strcmp($line[36],'Maison')==0 || strcmp($line[36],'Appartement')==0)){
                        $propertysale = new PropertySale();
                        $propertysale->price = doubleval($line[10]);
                        $propertysale->surface = $line[38]==''?0:intval($line[38]);
                        //$pieces = explode(" ", $line[8]);
                        $pieces2 = explode("/", $line[8]);
                        $propertysale->date = new DateTime($pieces2[2]. "-" . $pieces2[1] . "-" . $pieces2[0]);
                        $propertysale->department = $line[18];
                        $propertysale->region = $depToRegion[$line[18]];//TODO : "la surface ne nous interresse pas dans ce projet, je le remplace par le type de local, il faudra remplacer le nom de la-dite variable"
                        $manager->persist($propertysale);
                        if($cpt++%1000==0){// on limite le nombre de données acquise pour éviter une surcharge mémoire => meme en allouant 2G de memoire a php, l'acquisition de 100 000 données n'était pas possible
                            echo (++$percent)."% done \n";
                            if($percent == 100){
                                fseek($file,0,SEEK_END);
                            }
                        }
                        
                        
                    //}
                
                
            }
            fclose($file);
            $manager->flush();

        }

        
            //$propertysale->id = $i;
            
        /*for ($i = 0; $i < 20; $i++) {
            $propertysale = new PropertySale();
            //$propertysale->id = $i;
            $propertysale->price = 15;
            $propertysale->surface = 15;
            $propertysale->date = new DateTime('2012/12/12');;
            $propertysale->department = 'DPT';
            $propertysale->region = 'RGN';
            $manager->persist($propertysale);
        }*/

        
    }
}
