import { combineReducers } from 'redux';

function data(state = [], action) {
    switch(action.type) {
        case "SALES_BY_GRANULARITY_SUCCESS":
            return action.retrieved;
        default:
            return state;
    }
}

function filter(state={
    granularity: "month",
    lowerBound: "2015-01-01",
    upperBound: "2019-12-31",
}, action) {
    switch(action.type) {
        case "SALES_BY_GRANULARITY_UPDATE_FILTER":
            return {
                granularity: action.granularity,
                lowerBound: action.lowerBound,
                upperBound: action.upperBound,
            };
        default:
            return state;
    }
}

function error(state = null, action) {
    switch(action.type) {
        case "SALES_BY_GRANULARITY_ERROR":
            return action.error;
        default:
            return state;
    }
}

function loading(state = false, action) {
    switch(action.type) {
        case "SALES_BY_GRANULARITY_LOADING":
            return action.loading;
        default:
            return state;
    }
}

export default combineReducers({
    data,
    error,
    loading,
    filter,
});