import React from "react";
import { connect } from "react-redux";
import PropTypes from "prop-types";
import { Header, Footer } from "../layout"
import LineChart from "../charts/LineChart";

import * as actions from "../../actions/propertysale/average_surface_price";

class AverageSurfacePrice extends React.Component {
    static propTypes = {
        error: PropTypes.string,
        loading: PropTypes.bool.isRequired,
        data: PropTypes.array,
        fetch_data: PropTypes.func.isRequired,
    };

    componentDidMount() {
        this.props.fetch_data();
    }

    render() {
        return <div>
            <Header/>
            <h2>Evolution du prix du m² moyen</h2>
            {
                this.props.error &&
                <h3 style={{ color: "red" }}>{this.props.error}</h3>
            }
            {
                this.props.loading ?
                    <h3>Chargement...</h3>
                    :
                    <LineChart
                        data={this.props.data}
                        width={1000}
                        height={300}
                        xLabel={"Mois"}
                        yLabel={"K €"} />
            }
            <Footer/>
        </div>;
    }
}

const mapStateToProps = state => {
    const {
        propertysale: {
            averageSurfacePrice: {
                data = [],
                loading = false,
                error,
            } = {},
        } = {},
    } = state;

    return { data, loading, error };
}

const mapDispatchToProps = dispatch => ({
    fetch_data: () => dispatch(actions.fetch_data()),
});

export default connect(mapStateToProps, mapDispatchToProps)(AverageSurfacePrice);