import { fetch } from '../../utils/dataAccess';

export function loading(loading) {
    return { type: 'PROPERTY_SALE_SALES_BY_REGION_LOADING', loading };
}

export function success(retrieved) {
    return { type: 'PROPERTY_SALE_SALES_BY_REGION_SUCCESS', retrieved };
}

export function error(error) {
    return { type: 'PROPERTY_SALE_SALES_BY_REGION_ERROR', error };
}

export function fetch_data(year) {
    return dispatch => {
        dispatch(loading(true));

        return fetch("property_sales/sales_by_region/?year="+encodeURIComponent(year), { method: "GET" })
            .then(res => {
                dispatch(loading(false));
                return res.json();
            })
            .then(retrieved => dispatch(success(retrieved)))
            .catch(e => {
                dispatch(loading(false));
                dispatch(error(e.message));
            });
    };
}
