import { fetch } from '../../utils/dataAccess';

export function loading(loading) {
    return { type: 'PROPERTY_SALE_AVERAGE_SURFACE_PRICE_LOADING', loading };
}

export function success(retrieved) {
    return { type: 'PROPERTY_SALE_AVERAGE_SURFACE_PRICE_SUCCESS', retrieved };
}

export function error(error) {
    return { type: 'PROPERTY_SALE_AVERAGE_SURFACE_PRICE_ERROR', error };
}

export function fetch_data() {
    return dispatch => {
        dispatch(loading(true));

        return fetch("property_sales/average_surface_price", { method: "GET" })
            .then(res => {
                dispatch(loading(false));

                return res.json();
            })
            .then(retrieved => dispatch(success(retrieved)))
            .catch(e => {
                dispatch(loading(false));

                dispatch(error(e.message));
            });
    };
}
