<?php

namespace App\Tests;

use ApiPlatform\Core\Bridge\Symfony\Bundle\Test\ApiTestCase;
use App\Entity\Book;
use Hautelook\AliceBundle\PhpUnit\RefreshDatabaseTrait;

class AnalyticsTest extends ApiTestCase
{
    public function testAverageSurfacePriceOk(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/average_surface_price');

        // Asserts that the response has 200 Status Code
        $this->assertResponseIsSuccessful();
        // Asserts that the returned content type is JSON
        $this->assertResponseHeaderSame('content-type', 'application/json');
    }

    public function testSalesByRegionOk(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/sales_by_region', [
            'query' => [
                'year' => 2016 
            ],
        ]);

        // Asserts that the response has 200 Status Code
        $this->assertResponseIsSuccessful();
        // Asserts that the returned content type is JSON (the default)
        $this->assertResponseHeaderSame('content-type', 'application/json');
    }

    public function testSalesByRegionIncorrect(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/sales_by_region', [
            'query' => [
                'year' => 201677
            ],
        ]);

        // Assertion on the Status Code
        $this->assertResponseStatusCodeSame(400);
        // Asserts that the returned content type is Text (errors respond with texts)
        $this->assertResponseHeaderSame('content-type', 'application/text');

        $text = $response->getContent(false);
        assert(strcmp($text, 'Bad Request') !== false, "Tests the text returned with the error");
    }

    public function testSalesByRegionNoParameter(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/sales_by_region');

        // Assertion on the Status Code
        $this->assertResponseStatusCodeSame(400);
        // Asserts that the returned content type is Text (errors respond with texts)
        $this->assertResponseHeaderSame('content-type', 'application/text');
    }

    public function testSalesByGranularityOk(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/sales_by_granularity', [
            'query' => [
                'granularity' => 'day',
                'date_start' => '2018-11-24',
                'date_end' => '2018-12-24' 
            ],
        ]);

        // Asserts that the response has 200 Status Code
        $this->assertResponseIsSuccessful();
        // Asserts that the returned content type is JSON (the default)
        $this->assertResponseHeaderSame('content-type', 'application/json');
    }

    public function testSalesByGranularityGranularityIncorrect(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/sales_by_granularity', [
            'query' => [
                'granularity' => 'week',
                'date_start' => '2018-11-24',
                'date_end' => '2018-12-24' 
            ],
        ]);

        // Assertion on the Status Code
        $this->assertResponseStatusCodeSame(400);
        // Asserts that the returned content type is Text (errors respond with texts)
        $this->assertResponseHeaderSame('content-type', 'application/text');

        $text = $response->getContent(false);
        assert(strpos($text, 'wrong format') !== false, "Tests that the error is a wrong format");
    }

    public function testSalesByGranularityDateStartIncorrect(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/sales_by_granularity', [
            'query' => [
                'granularity' => 'day',
                'date_start' => 'arriva',
                'date_end' => '2018-12-24' 
            ],
        ]);

        // Assertion on the Status Code
        $this->assertResponseStatusCodeSame(400);
        // Asserts that the returned content type is Text (errors respond with texts)
        $this->assertResponseHeaderSame('content-type', 'application/text');

        $text = $response->getContent(false);
        assert(strpos($text, 'wrong format') !== false, "Tests that the error is a wrong format");
    }

    public function testSalesByGranularityDateEndIncorrect(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/sales_by_granularity', [
            'query' => [
                'granularity' => 'day',
                'date_start' => '2018-11-24',
                'date_end' => 'speedy gonzales' 
            ],
        ]);

        // Assertion on the Status Code
        $this->assertResponseStatusCodeSame(400);
        // Asserts that the returned content type is Text (errors respond with texts)
        $this->assertResponseHeaderSame('content-type', 'application/text');

        $text = $response->getContent(false);
        assert(strpos($text, 'wrong format') !== false, "Tests that the error is a wrong format");
    }

    public function testSalesByGranularityDateEndBeforeDateStart(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/sales_by_granularity', [
            'query' => [
                'granularity' => 'day',
                'date_start' => '2018-11-24',
                'date_end' => '2017-11-24' 
            ],
        ]);

        // Assertion on the Status Code
        $this->assertResponseStatusCodeSame(400);
        // Asserts that the returned content type is Text (errors respond with texts)
        $this->assertResponseHeaderSame('content-type', 'application/text');

        $text = $response->getContent(false);
        assert(strpos($text, 'before') !== false, "Tests that the error is a end before start");
    }

    public function testSalesByGranularityNoParameter(): void
    {
        $response = static::createClient()->request('GET', '/property_sales/sales_by_granularity');

        // Assertion on the Status Code
        $this->assertResponseStatusCodeSame(400);
        // Asserts that the returned content type is Text (errors respond with texts)
        $this->assertResponseHeaderSame('content-type', 'application/text');
    }
}
?>