<?php
namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Controller\AverageSurfacePrice;
use App\Controller\SalesByRegion;
use App\Controller\SalesByGranularity;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * A property sale entity.
 *
 * @ORM\Entity
 * @ApiResource(
 *  collectionOperations = {
 *      "get",
 *      "average_surface_price" = {
 *          "method" = "GET",
 *          "path" = "/property_sales/average_surface_price",
 *          "controller" = AverageSurfacePrice::class,
 *          "pagination_enabled" = false,
 *          "read" = false,
 *          "openapi_context" = {
 *              "summary" = "Gets the average surface price for mutations",
 *              "description" = "Gets the average surface price for mutations",
 *              "read" = "false"
 *          }
 *      },
 *      "sales_by_region" = {
 *          "method" = "GET",
 *          "path" = "/property_sales/sales_by_region",
 *          "controller" = SalesByRegion::class,
 *          "pagination_enabled" = false,
 *          "read" = false,
 *          "openapi_context" = {
 *              "summary" = "Gets the sales grouped by region",
 *              "description" = "Gets the sales grouped by region",
 *              "read" = "false",
 *              "parameters" = {
 *                  {
 *                      "in" = "query",
 *                      "name" = "year",
 *                      "required" = true,
 *                      "schema" = {
 *                          "type" = "integer",
 *                          "format" = "int64"
 *                      },
 *                      "example" = 2015
 *                  }
 *              }
 *          }   
 *      },
 *      "sales_by_granularity" = {
 *          "method" = "GET",
 *          "path" = "/property_sales/sales_by_granularity",
 *          "controller" = SalesByGranularity::class,
 *          "pagination_enabled" = false,
 *          "read" = false,
 *          "openapi_context" = {
 *              "summary" = "Gets the sales on a given interval with a given granularity",
 *              "description" = "Gets the sales on a given interval with a given granularity",
 *              "read" = "false",
 *              "parameters"= {
 *                  {
 *                      "in" = "query",
 *                      "name" = "granularity",
 *                      "required" = true,
 *                      "schema" = {
 *                          "type" = "string",
 *                          "enum" = {"year", "month", "day"}
 *                      },
 *                      "example" = "year"
 *                  },
 *                  {
 *                      "in" = "query",
 *                      "name" = "date_start",
 *                      "required" = true,
 *                      "schema" = {
 *                          "type" = "string",
 *                          "format" = "full-date"
 *                      },
 *                      "example" = "2015-12-24"
 *                  },
 *                  {
 *                      "in" = "query",
 *                      "name" = "date_end",
 *                      "required" = true,
 *                      "schema" = {
 *                          "type" = "string",
 *                          "format" = "full-date"
 *                      },
 *                      "example" = "2019-12-24"
 *                  }
 *              }
 *          }
 *      }
 *  },
 *  itemOperations={}
 * )
 */
class PropertySale
{
    /**
     * @var int The id of this book.
     *
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var float The price of the property
     * 
     * @ORM\Column(type="float")
     */
    public $price;

    /**
     * @var int The surface of the property, in square meters
     * 
     * @ORM\Column(type="integer")
     * @Assert\NotNull
     */
    public $surface;

    /**
     * @var \DateTimeInterface The sale date.
     *
     * @ORM\Column(type="datetime")
     * @Assert\NotNull
     */
    public $date;

    /**
     * @var string The property's department.
     * 
     * @ORM\Column(type="text")
     * @Assert\NotBlank
     */
    public $department;

    /**
     * @var string The property's region.
     * 
     * @ORM\Column(type="text")
     * @Assert\NotBlank
     */
    public $region;
    
    public function __construct()
    {
    }

    public function getId(): ?int
    {
        return $this->id;
    }
}
?>