<?php 
// si il vous manque des fichiers, pensez à mettre les fichiers valeursfoncières-*.txt dans le dossier DataFixture
namespace App\DataFixtures;

use App\Entity\PropertySale;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use \DateTime;

class PropertySaleFixture extends Fixture
{
    public function load(ObjectManager $manager)
    {
        $manager->getConnection()->getConfiguration()->setSQLLogger(null);
        $batch_size = 1000;
        
        $deps_json = file_get_contents(__DIR__.'/deps.json');
        $deps = json_decode($deps_json, true);

        $depToRegion = array();
        foreach ($deps as $key => $value) {
            $depToRegion[$value["code"]] = $value["nomRegion"];
        };

        $date_format = "d/m/Y";

        for($annee = 2015 ; $annee <= 2019 ; $annee++) {
            echo "Chargement des données de l'année ".$annee."\n\n";
                
            $file = fopen(__DIR__."/valeursfoncieres-".$annee.".txt", "r");   
            $cpt = 1;
            $line = fgetcsv($file,1024,"|");//enleve la premiere ligne contenant le descriptif des ventes

            while(!feof($file)){              
                $line = fgetcsv($file,1024,"|");
                // on ne prend en compte que les ventes, tout autre élément est ignoré car l'evenement peut influer sur le prix

                $mutation_nature = $line[9];
                $type = $line[36];
                
                $str_date = $line[8];
                $price = $line[10];
                $dep_code = $line[18];
                $surface = $line[38];

                
                if(PropertySaleFixture::isDataCorrect($mutation_nature, $type, $str_date, $price, $dep_code, $surface)){
                    $propertysale = new PropertySale();
                    $propertysale->price = doubleval($price);
                    $propertysale->surface = intval($surface);
                    $propertysale->date = DateTime::createFromFormat($date_format, $str_date);
                    $propertysale->department = $dep_code;
                    $propertysale->region = $depToRegion[$dep_code];

                    $manager->persist($propertysale);

                    if($cpt++%$batch_size==0){
                        // on limite le nombre de données acquise pour éviter une surcharge mémoire                                 
                        $manager->flush();
                        $manager->clear();
                        echo $batch_size." lignes ajoutées (".$cpt." en tout) à la base de données\n";
                    }       
                }
            }

            echo "Fin de l'ajout des données, ".$cpt." lignes ajoutées\n\n";
            $manager->flush();
            $manager->clear();
            fclose($file);
        }
    }

    private static function isDataCorrect($mutation_nature, $type, $date, $price, $department_code, $surface) {
        return strpos(strtolower($mutation_nature), "vente") !== false &&
            (strcmp($type, 'Maison') == 0 || strcmp($type, 'Appartement') == 0) &&
            $date != null && $date != "" &&
            $price != null && $price != "0" && $price != "" &&
            $surface != null && $surface != "0" && $surface != "" &&
            $department_code != null && $department_code != "";
    }
}
