package iwocs.graphs.propagation;

public class PropagationStepInfos {
  private long initialI;
  private long initialS;

  private long newI;
  private long newS;

  public PropagationStepInfos() {
    this.initialI = 0;
    this.initialS = 0;

    this.newI = 0;
    this.newS = 0;
  }

  public PropagationStepInfos(long initialI, long initialS) {
    this.initialI = initialI;
    this.initialS = initialS;

    this.newI = 0;
    this.newS = 0;
  }

  public PropagationStepInfos(long initialI, long initialS, long newI, long newS) {
    this.initialI = initialI;
    this.initialS = initialS;

    this.newI = newI;
    this.newS = newS;
  }

  /**
   * @return the newI
   */
  public long getNewI() {
    return newI;
  }

  /**
   * @return the newS
   */
  public long getNewS() {
    return newS;
  }

  /**
   * @return the initialI
   */
  public long getInitialI() {
    return initialI;
  }

  /**
   * @return the initialS
   */
  public long getInitialS() {
    return initialS;
  }

  /**
   * Get the number of infected nodes at the end of the step.
   * 
   * @return infected at step's end.
   */
  public long getFinalI() {
    return this.initialI + this.newI;
  }

  /**
   * Get the number of susceptible nodes at the end of the step.
   * 
   * @return susceptible at step's end.
   */
  public long getFinalS() {
    return this.initialS + this.newS;
  }

  /**
   * @param newI the newI to set
   */
  public void setNewI(long newI) {
    this.newI = newI;
  }

  /**
   * @param newS the newS to set
   */
  public void setNewS(long newS) {
    this.newS = newS;
  }

  /**
   * @param initialI the initialI to set
   */
  public void setInitialI(long initialI) {
    this.initialI = initialI;
  }

  /**
   * @param initialS the initialS to set
   */
  public void setInitialS(long initialS) {
    this.initialS = initialS;
  }

  /**
   * Increments new infected count.
   */
  public void incrementNewI() {
    this.newI++;
  }

  /**
   * Increments new susceptible count.
   */
  public void incrementNewS() {
    this.newS++;
  }
}