package iwocs.graphs.propagation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;

public class PropagationInfos {
  private int nbSteps;
  private List<PropagationStepInfos> steps;

  /**
   * Basic constructor.
   */
  public PropagationInfos() {
    this.nbSteps = 0;
    this.steps = new ArrayList<>();
  }

  /**
   * Adds a step's infos to the steps list.
   * 
   * @param stepInfos the infos to add.
   */
  public void addStep(PropagationStepInfos stepInfos) {
    this.steps.add(stepInfos);
    this.nbSteps++;
  }

  /**
   * Export steps infos to a file.
   * 
   * @param destFile the file in which we write the steps.
   */
  public void export(String destFile) {
    try (BufferedWriter w = new BufferedWriter(new FileWriter(new File(destFile)))) {
      for (PropagationStepInfos stepInfos : this.steps)
        w.write(
            String.format("%d\t%d\t%d\n", steps.indexOf(stepInfos), stepInfos.getInitialI(), stepInfos.getInitialS()));

      PropagationStepInfos lastStep = this.steps.get(this.nbSteps - 1);

      w.write(String.format("%d\t%d\t%d\n", this.nbSteps, lastStep.getFinalI(), lastStep.getFinalS()));
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Get the infos of a given step.
   * 
   * @param noStep the step's number.
   * @return the infos of the given step.
   */
  public PropagationStepInfos getStep(int noStep) {
    return this.steps.get(noStep);
  }

  /**
   * @return the nbSteps
   */
  public int getNbSteps() {
    return nbSteps;
  }

  /**
   * @return the steps
   */
  public List<PropagationStepInfos> getSteps() {
    return steps;
  }
}