set terminal png

# DEGREES

set logscale xy

set xlabel "k"
set ylabel "p(k)"

# Distribution des degrés (terrain)
set output "images/nerds/nerds_degrees_distribution.png"

plot "data/nerds_degrees_distrib"

# Distribution des degrés (aléatoire)
set output "images/random/random_degrees_distribution.png"

plot "data/random_degrees_distrib"

# Distribution des degrés (préférentiel)
set output "images/preferential/preferential_degrees_distribution.png"

plot "data/preferential_degrees_distrib"

# Comparaison des degrés

set output "images/degrees_distributions_comparison.png"

plot "data/nerds_degrees_distrib" lt rgb "black", "data/random_degrees_distrib" lt rgb "red", "data/preferential_degrees_distrib" lt rgb "blue"

# DISTANCES

unset logscale xy

set xlabel "d"
set ylabel "p(d)"

# Distribution des distances (terrain)
set output "images/nerds/nerds_distances_distribution.png"

plot "data/nerds_distances_distrib"

# Distribution des distances (aléatoire)
set output "images/random/random_distances_distribution.png"

plot "data/random_distances_distrib"

# Distribution des distances (préférentiel)
set output "images/preferential/preferential_distances_distribution.png"

plot "data/preferential_distances_distrib"

# Comparaison des distances

set output "images/distances_distributions_comparison.png"

plot "data/nerds_distances_distrib" lt rgb "black", "data/random_distances_distrib" lt rgb "red", "data/preferential_distances_distrib" lt rgb "blue"