# Netlysis

## Travaux d'analyse sur un cas de réseau d'intéraction
### Réseau de collaboration scientifique

## Question 2

Nous avons effectué ces mesures sur le réseau à analyser :

```
|N| = 317080
|L| = 1049866
 k  = 6.622
 C  = 0.632
```

Le coefficient moyen de clustering d'un réseau aléatoire de même taille et de même degré moyen est :

$`Ci = p = \langle k \rangle \div N = 6,622 \div 137080 \ = 0,000048308`$

## Question 3

Le réseau scientifique est bel et bien connexe. Puisque son degré moyen
est de 6,622, et qu'un réseau aléatoire atteint un régime pleinement
connecté à partir d'un degré moyen d'environ 4,5, alors on peut dire qu'un
réseau aléatoire avec ces mêmes caractéristiques serait connexe.

## Question 4

![Distribution des degrés](images/analysis/nerds/nerds_degrees_distribution.png)

*Distribution des degrés dans le réseau de terrain*

Coéfficients trouvés pour la loi de puissance : c -> 10.806, gamma -> 2.717

## Question 5

La distance moyenne calculée sur un échantillon de 1000
noeuds est de 6.81. Pour savoir si ce réseau est un
réseau petit monde, il faut vérifier que sa distance moyenne
soit d'environ $`\ln N \div \ln \langle k \rangle`$.

La distance moyenne dans un réseau aléatoire
aux mêmes caractéristiques de taille et de degré moyen est d'environ :

$`\langle d \rangle = \ln N / \ln \langle k \rangle = \ln 317080 / \ln 6.622 \approx 6.701`$

$`\ln N / \ln \langle k \rangle \approxeq \langle d \rangle`$ ce réseau est
donc un réseau petit monde.

![Distribution des distances](images/analysis/nerds/nerds_distances_distribution.png)

*Distribution des distances dans le réseau de terrain*

Après traçage de la distribution, je conjecture que la loi de cette distribution
est une loi normale centrée autour de la moyenne $`\approx 6.7`$.

## Question 6

| *Mesure*                |   Terrain   | Aléatoire | Préférentiel
|-------------------------|-------------|-----------|-------------
| $`\|N\|`$               | 317 082     | 317 082   | 317 082
| $`\|L\|`$               | 1 049 866   | 1 050 904 | 1 268 401
| $`\langle k \rangle`$   | 6.622       | 6.628     | 8.000
| $`\langle C \rangle`$   | 0.632       | 0.000     | 0.000
| $`\langle d \rangle`$   | 6.849       | 6.919     | 4.859
| Connexe                 | ✓           | ❌         | ✓

Les mesures de clustering et de la distance moyenne
prédits sont cohérents avec ceux observés pour le réseau
aléatoire.

### Comparaison des distributions

![Comparaison des distributions de degrés entre les trois graphes](images/analysis/degrees_distributions_comparison.png)

*Comparaison des distributions de degrés entre les trois graphes*

On peut voir que la distribution des degrés sur le
graphe préférentiiel se rapproche beaucoup de celle
du graphe de terrain. En revanche la distribution
dans un réseau aléatoire est bien différente.

![Comparaison des distributions de distances entre les trois graphes](images/analysis/distances_distributions_comparison.png)

*Comparaison des distributions de distances entre les trois graphes*

Au final, on peut dire qu'un graphe à attachement préférentiel
est ce qui se rapproche le plus d'un graphe de terrain en termes
de distribution de degrés, même s'il n'est pas ressemblant sur
d'autres points comme les distances ou le coefficient de clustering.

Le réseau aléatoire n'est quant à lui pas une bonne stratégie de
génération pour obtenir un réseau proche d'un réseau
de terrain.

# Travaux d'analyse et de simulation d'une propagation dans 
le réseau de collaboration

## Question 1

On a $`\beta = \frac{1}{7}`$ et $`\mu = \frac{1}{14}`$, on a donc
$`\lambda = \frac{\beta}{\mu} = 2`$ comme taux de propagation.

On a également le seuil épidémique
$`\lambda c = \frac{\langle k \rangle}{\langle k^2 \rangle}`$
avec $`\langle k \rangle = 6.622`$ et $`\langle k^2 \rangle = 143,631`$
qui vaut $`\lambda c \approx 0.046`$.
Le seuil épidémique d'un réseau aléatoire au même degré moyen
serait $`\lambda c = \frac{1}{\langle k \rangle + 1} \approx 0.131`$.
On peut lier cette différence aux divergences en termes de clustering
entre les deux graphes.

## Question 2

![Comparaison de l'évolution du virus dans le réseau avec trois stratégies d'immunisation différentes](images/propagation/infected_rate_evolution_comparison.png)

On peut voir que la stratégie d'immunisation aléatoire ne permet dans
le pire des cas que de retarder l'explosion virale. Quant à l'immunisation
sélective appliquée à 50% du graphe, elle permet d'endiguer très
éfficacement le virus en déconnectant le graphe.

## Question 3

### Résultats

$`\langle k \rangle (g0) = 6.599`$

$`\langle k \rangle (g1) = 11.358`$

On peut voir que le degré moyen du groupe 1 est nettement supérieur.
Ceci est permis grâce à l'immunisation sélective, qui ne prend non
pas des noeuds au hasard, mais des arêtes. Les hubs étant les noeuds
à l'extrémité d'une grande part des arêtes d'un graphe, nous avons
donc plus de chances de tomber sur eux, qui ont un degré bien plus
élevé que le noeud lambda. Le groupe 1 contient donc plus noeuds à
fort degré, d'où son degré moyen supérieur.

## Question 4

### Résultats

$`\lambda c(aléatoire) \approx 0.083`$\
$`\lambda c(sélective) \approx 0.192`$

On voit que le seuil du graphe immunisé de façon sélective
est bien supérieur, mais quand même pas assez pour être
sûrs que la maladie disparaisse.